/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.vacuumd.Uei;

@XmlRootElement(name="auto-event")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="vacuumd-configuration.xsd")
public class AutoEvent
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="fields")
    private String m_fields;
    @XmlElement(name="uei", required=true)
    private Uei m_uei;

    public AutoEvent() {
    }

    public AutoEvent(String name, String fields, Uei uei) {
        this.setName(name);
        this.setFields(fields);
        this.setUei(uei);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<String> getFields() {
        return Optional.ofNullable(this.m_fields);
    }

    public void setFields(String fields) {
        this.m_fields = ConfigUtils.normalizeString(fields);
    }

    public Uei getUei() {
        return this.m_uei;
    }

    public void setUei(Uei uei) {
        this.m_uei = ConfigUtils.assertNotNull(uei, "uei");
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_fields, this.m_uei);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoEvent) {
            AutoEvent that = (AutoEvent)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_fields, that.m_fields) && Objects.equals(this.m_uei, that.m_uei);
        }
        return false;
    }
}

