/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Target
implements Serializable {
    private String _interval = "0s";
    private String _name;
    private String _autoNotify;
    private List<String> _commandList;

    public Target() {
        this.setInterval("0s");
        this._commandList = new ArrayList<String>();
    }

    public void addCommand(String vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(vCommand);
    }

    public void addCommand(int index, String vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(index, vCommand);
    }

    public Enumeration<String> enumerateCommand() {
        return Collections.enumeration(this._commandList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Target) {
            Target temp = (Target)obj;
            if (this._interval != null) {
                if (temp._interval == null) {
                    return false;
                }
                if (!this._interval.equals(temp._interval)) {
                    return false;
                }
            } else if (temp._interval != null) {
                return false;
            }
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._autoNotify != null) {
                if (temp._autoNotify == null) {
                    return false;
                }
                if (!this._autoNotify.equals(temp._autoNotify)) {
                    return false;
                }
            } else if (temp._autoNotify != null) {
                return false;
            }
            if (this._commandList != null) {
                if (temp._commandList == null) {
                    return false;
                }
                if (!this._commandList.equals(temp._commandList)) {
                    return false;
                }
            } else if (temp._commandList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAutoNotify() {
        return this._autoNotify;
    }

    public String getCommand(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._commandList.size()) {
            throw new IndexOutOfBoundsException("getCommand: Index value '" + index + "' not in range [0.." + (this._commandList.size() - 1) + "]");
        }
        return this._commandList.get(index);
    }

    public String[] getCommand() {
        String[] array = new String[]{};
        return this._commandList.toArray(array);
    }

    public List<String> getCommandCollection() {
        return this._commandList;
    }

    public int getCommandCount() {
        return this._commandList.size();
    }

    public String getInterval() {
        return this._interval;
    }

    public String getName() {
        return this._name;
    }

    public int hashCode() {
        int result = 17;
        if (this._interval != null) {
            result = 37 * result + this._interval.hashCode();
        }
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._autoNotify != null) {
            result = 37 * result + this._autoNotify.hashCode();
        }
        if (this._commandList != null) {
            result = 37 * result + this._commandList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateCommand() {
        return this._commandList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCommand() {
        this._commandList.clear();
    }

    public boolean removeCommand(String vCommand) {
        boolean removed = this._commandList.remove(vCommand);
        return removed;
    }

    public String removeCommandAt(int index) {
        String obj = this._commandList.remove(index);
        return obj;
    }

    public void setAutoNotify(String autoNotify) {
        this._autoNotify = autoNotify;
    }

    public void setCommand(int index, String vCommand) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._commandList.size()) {
            throw new IndexOutOfBoundsException("setCommand: Index value '" + index + "' not in range [0.." + (this._commandList.size() - 1) + "]");
        }
        this._commandList.set(index, vCommand);
    }

    public void setCommand(String[] vCommandArray) {
        this._commandList.clear();
        for (int i = 0; i < vCommandArray.length; ++i) {
            this._commandList.add(vCommandArray[i]);
        }
    }

    public void setCommand(List<String> vCommandList) {
        this._commandList.clear();
        this._commandList.addAll(vCommandList);
    }

    public void setCommandCollection(List<String> commandList) {
        this._commandList = commandList;
    }

    public void setInterval(String interval) {
        this._interval = interval;
    }

    public void setName(String name) {
        this._name = name;
    }

    public static Target unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Target)Unmarshaller.unmarshal(Target.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

