/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.vacuumd.ActionEvents;
import org.opennms.netmgt.config.vacuumd.Actions;
import org.opennms.netmgt.config.vacuumd.AutoEvents;
import org.opennms.netmgt.config.vacuumd.Automations;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Triggers;

@XmlRootElement(name="VacuumdConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class VacuumdConfiguration
implements Serializable {
    private static final long serialVersionUID = -3370783056683052503L;
    @XmlAttribute(name="period")
    private Integer _period;
    @XmlElement(name="statement")
    private List<Statement> _statementList = new ArrayList<Statement>(0);
    @XmlElement(name="automations")
    private Automations _automations = new Automations();
    @XmlElement(name="triggers")
    private Triggers _triggers = new Triggers();
    @XmlElement(name="actions")
    private Actions _actions = new Actions();
    @XmlElement(name="auto-events")
    private AutoEvents _autoEvents = new AutoEvents();
    @XmlElement(name="action-events")
    private ActionEvents _actionEvents = new ActionEvents();

    public VacuumdConfiguration() {
    }

    public VacuumdConfiguration(int period, List<Statement> statements, Automations automations, Triggers triggers, Actions actions, AutoEvents autoEvents, ActionEvents actionEvents) {
        this.setPeriod(period);
        this.setStatement(statements);
        this.setAutomations(automations);
        this.setTriggers(triggers);
        this.setActions(actions);
        this.setAutoEvents(autoEvents);
        this.setActionEvents(actionEvents);
    }

    public void addStatement(Statement vStatement) throws IndexOutOfBoundsException {
        this._statementList.add(vStatement);
    }

    public void addStatement(int index, Statement vStatement) throws IndexOutOfBoundsException {
        this._statementList.add(index, vStatement);
    }

    public Enumeration<Statement> enumerateStatement() {
        return Collections.enumeration(this._statementList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VacuumdConfiguration other = (VacuumdConfiguration)obj;
        if (this._actionEvents == null ? other._actionEvents != null : !this._actionEvents.equals(other._actionEvents)) {
            return false;
        }
        if (this._actions == null ? other._actions != null : !this._actions.equals(other._actions)) {
            return false;
        }
        if (this._autoEvents == null ? other._autoEvents != null : !this._autoEvents.equals(other._autoEvents)) {
            return false;
        }
        if (this._automations == null ? other._automations != null : !this._automations.equals(other._automations)) {
            return false;
        }
        if (this._period == null ? other._period != null : !this._period.equals(other._period)) {
            return false;
        }
        if (this._statementList == null ? other._statementList != null : !this._statementList.equals(other._statementList)) {
            return false;
        }
        return !(this._triggers == null ? other._triggers != null : !this._triggers.equals(other._triggers));
    }

    public ActionEvents getActionEvents() {
        return this._actionEvents;
    }

    public Actions getActions() {
        return this._actions;
    }

    public AutoEvents getAutoEvents() {
        return this._autoEvents;
    }

    public Automations getAutomations() {
        return this._automations;
    }

    public int getPeriod() {
        return this._period == null ? 0 : this._period;
    }

    public Statement getStatement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._statementList.size()) {
            throw new IndexOutOfBoundsException("getStatement: Index value '" + index + "' not in range [0.." + (this._statementList.size() - 1) + "]");
        }
        return this._statementList.get(index);
    }

    public Statement[] getStatement() {
        Statement[] array = new Statement[]{};
        return this._statementList.toArray(array);
    }

    public List<Statement> getStatementCollection() {
        return this._statementList;
    }

    public int getStatementCount() {
        return this._statementList.size();
    }

    public Triggers getTriggers() {
        return this._triggers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._actionEvents == null ? 0 : this._actionEvents.hashCode());
        result = 31 * result + (this._actions == null ? 0 : this._actions.hashCode());
        result = 31 * result + (this._autoEvents == null ? 0 : this._autoEvents.hashCode());
        result = 31 * result + (this._automations == null ? 0 : this._automations.hashCode());
        result = 31 * result + (this._period == null ? 0 : this._period.hashCode());
        result = 31 * result + (this._statementList == null ? 0 : this._statementList.hashCode());
        result = 31 * result + (this._triggers == null ? 0 : this._triggers.hashCode());
        return result;
    }

    public Iterator<Statement> iterateStatement() {
        return this._statementList.iterator();
    }

    public void removeAllStatement() {
        this._statementList.clear();
    }

    public boolean removeStatement(Statement vStatement) {
        return this._statementList.remove(vStatement);
    }

    public Statement removeStatementAt(int index) {
        return this._statementList.remove(index);
    }

    public void setActionEvents(ActionEvents actionEvents) {
        this._actionEvents = actionEvents;
    }

    public void setActions(Actions actions) {
        this._actions = actions;
    }

    public void setAutoEvents(AutoEvents autoEvents) {
        this._autoEvents = autoEvents;
    }

    public void setAutomations(Automations automations) {
        this._automations = automations;
    }

    public void setPeriod(int period) {
        this._period = period;
    }

    public void setStatement(int index, Statement vStatement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._statementList.size()) {
            throw new IndexOutOfBoundsException("setStatement: Index value '" + index + "' not in range [0.." + (this._statementList.size() - 1) + "]");
        }
        this._statementList.set(index, vStatement);
    }

    public void setStatement(Statement[] vStatementArray) {
        this._statementList.clear();
        for (int i = 0; i < vStatementArray.length; ++i) {
            this._statementList.add(vStatementArray[i]);
        }
    }

    public void setStatement(List<Statement> vStatementList) {
        this._statementList.clear();
        this._statementList.addAll(vStatementList);
    }

    public void setTriggers(Triggers triggers) {
        this._triggers = triggers;
    }
}

