/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.javamail.JavamailProperty;
import org.opennms.netmgt.config.javamail.ReadmailHost;
import org.opennms.netmgt.config.javamail.UserAuth;

@XmlRootElement(name="readmail-config", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReadmailConfig
implements Serializable {
    private static final long serialVersionUID = -8838663418389605178L;
    @XmlAttribute(name="debug")
    private Boolean _debug;
    @XmlAttribute(name="mail-folder")
    private String _mailFolder;
    @XmlAttribute(name="attempt-interval")
    private Long _attemptInterval;
    @XmlAttribute(name="delete-all-mail")
    private Boolean _deleteAllMail;
    @XmlAttribute(name="name")
    private String _name;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> _javamailPropertyList = new ArrayList<JavamailProperty>();
    @XmlElement(name="readmail-host")
    private ReadmailHost _readmailHost;
    @XmlElement(name="user-auth")
    private UserAuth _userAuth;

    public void addJavamailProperty(JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        this._javamailPropertyList.add(vJavamailProperty);
    }

    public void addJavamailProperty(int index, JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        this._javamailPropertyList.add(index, vJavamailProperty);
    }

    public Enumeration<JavamailProperty> enumerateJavamailProperty() {
        return Collections.enumeration(this._javamailPropertyList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailConfig) {
            ReadmailConfig temp = (ReadmailConfig)obj;
            if (this._debug != temp._debug) {
                return false;
            }
            if (this._mailFolder != null) {
                if (temp._mailFolder == null) {
                    return false;
                }
                if (!this._mailFolder.equals(temp._mailFolder)) {
                    return false;
                }
            } else if (temp._mailFolder != null) {
                return false;
            }
            if (this._attemptInterval != temp._attemptInterval) {
                return false;
            }
            if (this._deleteAllMail != temp._deleteAllMail) {
                return false;
            }
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._javamailPropertyList != null) {
                if (temp._javamailPropertyList == null) {
                    return false;
                }
                if (!this._javamailPropertyList.equals(temp._javamailPropertyList)) {
                    return false;
                }
            } else if (temp._javamailPropertyList != null) {
                return false;
            }
            if (this._readmailHost != null) {
                if (temp._readmailHost == null) {
                    return false;
                }
                if (!this._readmailHost.equals(temp._readmailHost)) {
                    return false;
                }
            } else if (temp._readmailHost != null) {
                return false;
            }
            if (this._userAuth != null) {
                if (temp._userAuth == null) {
                    return false;
                }
                if (!this._userAuth.equals(temp._userAuth)) {
                    return false;
                }
            } else if (temp._userAuth != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Long getAttemptInterval() {
        return this._attemptInterval == null ? 1000L : this._attemptInterval;
    }

    public Boolean isDebug() {
        return this._debug == null ? Boolean.TRUE : this._debug;
    }

    public Boolean isDeleteAllMail() {
        return this._deleteAllMail != false ? Boolean.FALSE : this._deleteAllMail;
    }

    public JavamailProperty getJavamailProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._javamailPropertyList.size()) {
            throw new IndexOutOfBoundsException("getJavamailProperty: Index value '" + index + "' not in range [0.." + (this._javamailPropertyList.size() - 1) + "]");
        }
        return this._javamailPropertyList.get(index);
    }

    public JavamailProperty[] getJavamailProperty() {
        JavamailProperty[] array = new JavamailProperty[]{};
        return this._javamailPropertyList.toArray(array);
    }

    public List<JavamailProperty> getJavamailPropertyCollection() {
        return this._javamailPropertyList;
    }

    public int getJavamailPropertyCount() {
        return this._javamailPropertyList.size();
    }

    public String getMailFolder() {
        return this._mailFolder == null ? "INBOX" : this._mailFolder;
    }

    public String getName() {
        return this._name;
    }

    public ReadmailHost getReadmailHost() {
        return this._readmailHost;
    }

    public UserAuth getUserAuth() {
        return this._userAuth;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._debug != false ? 0 : 1);
        if (this._mailFolder != null) {
            result = 37 * result + this._mailFolder.hashCode();
        }
        result = 37 * result + (int)(this._attemptInterval ^ this._attemptInterval >>> 32);
        result = 37 * result + (this._deleteAllMail != false ? 0 : 1);
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._javamailPropertyList != null) {
            result = 37 * result + this._javamailPropertyList.hashCode();
        }
        if (this._readmailHost != null) {
            result = 37 * result + this._readmailHost.hashCode();
        }
        if (this._userAuth != null) {
            result = 37 * result + this._userAuth.hashCode();
        }
        return result;
    }

    public Iterator<JavamailProperty> iterateJavamailProperty() {
        return this._javamailPropertyList.iterator();
    }

    public void removeAllJavamailProperty() {
        this._javamailPropertyList.clear();
    }

    public boolean removeJavamailProperty(JavamailProperty vJavamailProperty) {
        return this._javamailPropertyList.remove(vJavamailProperty);
    }

    public JavamailProperty removeJavamailPropertyAt(int index) {
        return this._javamailPropertyList.remove(index);
    }

    public void setAttemptInterval(Long attemptInterval) {
        this._attemptInterval = attemptInterval;
    }

    public void setDebug(Boolean debug) {
        this._debug = debug;
    }

    public void setDeleteAllMail(Boolean deleteAllMail) {
        this._deleteAllMail = deleteAllMail;
    }

    public void setJavamailProperty(int index, JavamailProperty vJavamailProperty) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._javamailPropertyList.size()) {
            throw new IndexOutOfBoundsException("setJavamailProperty: Index value '" + index + "' not in range [0.." + (this._javamailPropertyList.size() - 1) + "]");
        }
        this._javamailPropertyList.set(index, vJavamailProperty);
    }

    public void setJavamailProperty(JavamailProperty[] vJavamailPropertyArray) {
        this._javamailPropertyList.clear();
        for (int i = 0; i < vJavamailPropertyArray.length; ++i) {
            this._javamailPropertyList.add(vJavamailPropertyArray[i]);
        }
    }

    public void setJavamailProperty(List<JavamailProperty> vJavamailPropertyList) {
        this._javamailPropertyList.clear();
        this._javamailPropertyList.addAll(vJavamailPropertyList);
    }

    public void setJavamailPropertyCollection(List<JavamailProperty> javamailPropertyList) {
        this._javamailPropertyList = javamailPropertyList;
    }

    public void setMailFolder(String mailFolder) {
        this._mailFolder = mailFolder;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setReadmailHost(ReadmailHost readmailHost) {
        this._readmailHost = readmailHost;
    }

    public void setUserAuth(UserAuth userAuth) {
        this._userAuth = userAuth;
    }
}

