/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.hardware;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.hardware.HwExtension;
import org.opennms.netmgt.config.hardware.MibObj;
import org.opennms.netmgt.snmp.SnmpObjId;

@XmlRootElement(name="hardware-inventory-adapter-configuration")
@XmlAccessorType(value=XmlAccessType.NONE)
public class HwInventoryAdapterConfiguration
implements Serializable {
    private static final long serialVersionUID = 3072173311787052813L;
    List<HwExtension> extensions = new ArrayList<HwExtension>();

    @XmlElement(name="hw-extension")
    public List<HwExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<HwExtension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(HwExtension extension) {
        this.extensions.add(extension);
    }

    public List<SnmpObjId> getVendorOid(String nodeSysOid) {
        ArrayList<SnmpObjId> vendorOidList = new ArrayList<SnmpObjId>();
        for (HwExtension ext : this.getExtensions()) {
            if (!nodeSysOid.startsWith(ext.getSysOidMask())) continue;
            for (MibObj obj : ext.getMibObjects()) {
                vendorOidList.add(obj.getOid());
            }
        }
        return vendorOidList;
    }

    public Map<String, String> getReplacementMap() {
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (HwExtension ext : this.getExtensions()) {
            for (MibObj obj : ext.getMibObjects()) {
                if (obj.getReplace() == null || obj.getReplace().trim().isEmpty()) continue;
                replacementMap.put(obj.getAlias(), obj.getReplace());
            }
        }
        return replacementMap;
    }

    public String toString() {
        return "HwInventoryAdapterConfiguration [extensions=" + this.extensions + "]";
    }
}

