/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.AutoAcknowledgeAlarm;
import org.opennms.netmgt.config.notifd.Queue;
import org.xml.sax.ContentHandler;

public class NotifdConfiguration
implements Serializable {
    private String _status;
    private String _pagesSent = "SELECT * FROM notifications";
    private String _nextNotifId = "SELECT nextval('notifynxtid')";
    private String _nextUserNotifId = "SELECT nextval('userNotifNxtId')";
    private String _nextGroupId = "SELECT nextval('notifygrpid')";
    private String _serviceIdSql = "SELECT serviceID from service where serviceName = ?";
    private String _outstandingNoticesSql = "SELECT notifyid FROM notifications where notifyId = ? AND respondTime is not null";
    private String _acknowledgeIdSql = "SELECT notifyid FROM notifications WHERE eventuei=? AND nodeid=? AND interfaceid=? AND serviceid=?";
    private String _acknowledgeUpdateSql = "UPDATE notifications SET answeredby=?, respondtime=? WHERE notifyId=?";
    private boolean _matchAll;
    private boolean _has_matchAll;
    private String _emailAddressCommand = "javaEmail";
    private boolean _numericSkipResolutionPrefix = false;
    private boolean _has_numericSkipResolutionPrefix;
    private AutoAcknowledgeAlarm _autoAcknowledgeAlarm;
    private List<AutoAcknowledge> _autoAcknowledgeList;
    private List<Queue> _queueList;
    private List<String> _outageCalendarList;

    public NotifdConfiguration() {
        this.setPagesSent("SELECT * FROM notifications");
        this.setNextNotifId("SELECT nextval('notifynxtid')");
        this.setNextUserNotifId("SELECT nextval('userNotifNxtId')");
        this.setNextGroupId("SELECT nextval('notifygrpid')");
        this.setServiceIdSql("SELECT serviceID from service where serviceName = ?");
        this.setOutstandingNoticesSql("SELECT notifyid FROM notifications where notifyId = ? AND respondTime is not null");
        this.setAcknowledgeIdSql("SELECT notifyid FROM notifications WHERE eventuei=? AND nodeid=? AND interfaceid=? AND serviceid=?");
        this.setAcknowledgeUpdateSql("UPDATE notifications SET answeredby=?, respondtime=? WHERE notifyId=?");
        this.setEmailAddressCommand("javaEmail");
        this._autoAcknowledgeList = new ArrayList<AutoAcknowledge>();
        this._queueList = new ArrayList<Queue>();
        this._outageCalendarList = new ArrayList<String>();
    }

    public void addAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(vAutoAcknowledge);
    }

    public void addAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(index, vAutoAcknowledge);
    }

    public void addOutageCalendar(String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(vOutageCalendar);
    }

    public void addOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(index, vOutageCalendar);
    }

    public void addQueue(Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(vQueue);
    }

    public void addQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(index, vQueue);
    }

    public void deleteMatchAll() {
        this._has_matchAll = false;
    }

    public void deleteNumericSkipResolutionPrefix() {
        this._has_numericSkipResolutionPrefix = false;
    }

    public Enumeration<AutoAcknowledge> enumerateAutoAcknowledge() {
        return Collections.enumeration(this._autoAcknowledgeList);
    }

    public Enumeration<String> enumerateOutageCalendar() {
        return Collections.enumeration(this._outageCalendarList);
    }

    public Enumeration<Queue> enumerateQueue() {
        return Collections.enumeration(this._queueList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotifdConfiguration) {
            NotifdConfiguration temp = (NotifdConfiguration)obj;
            if (this._status != null) {
                if (temp._status == null) {
                    return false;
                }
                if (!this._status.equals(temp._status)) {
                    return false;
                }
            } else if (temp._status != null) {
                return false;
            }
            if (this._pagesSent != null) {
                if (temp._pagesSent == null) {
                    return false;
                }
                if (!this._pagesSent.equals(temp._pagesSent)) {
                    return false;
                }
            } else if (temp._pagesSent != null) {
                return false;
            }
            if (this._nextNotifId != null) {
                if (temp._nextNotifId == null) {
                    return false;
                }
                if (!this._nextNotifId.equals(temp._nextNotifId)) {
                    return false;
                }
            } else if (temp._nextNotifId != null) {
                return false;
            }
            if (this._nextUserNotifId != null) {
                if (temp._nextUserNotifId == null) {
                    return false;
                }
                if (!this._nextUserNotifId.equals(temp._nextUserNotifId)) {
                    return false;
                }
            } else if (temp._nextUserNotifId != null) {
                return false;
            }
            if (this._nextGroupId != null) {
                if (temp._nextGroupId == null) {
                    return false;
                }
                if (!this._nextGroupId.equals(temp._nextGroupId)) {
                    return false;
                }
            } else if (temp._nextGroupId != null) {
                return false;
            }
            if (this._serviceIdSql != null) {
                if (temp._serviceIdSql == null) {
                    return false;
                }
                if (!this._serviceIdSql.equals(temp._serviceIdSql)) {
                    return false;
                }
            } else if (temp._serviceIdSql != null) {
                return false;
            }
            if (this._outstandingNoticesSql != null) {
                if (temp._outstandingNoticesSql == null) {
                    return false;
                }
                if (!this._outstandingNoticesSql.equals(temp._outstandingNoticesSql)) {
                    return false;
                }
            } else if (temp._outstandingNoticesSql != null) {
                return false;
            }
            if (this._acknowledgeIdSql != null) {
                if (temp._acknowledgeIdSql == null) {
                    return false;
                }
                if (!this._acknowledgeIdSql.equals(temp._acknowledgeIdSql)) {
                    return false;
                }
            } else if (temp._acknowledgeIdSql != null) {
                return false;
            }
            if (this._acknowledgeUpdateSql != null) {
                if (temp._acknowledgeUpdateSql == null) {
                    return false;
                }
                if (!this._acknowledgeUpdateSql.equals(temp._acknowledgeUpdateSql)) {
                    return false;
                }
            } else if (temp._acknowledgeUpdateSql != null) {
                return false;
            }
            if (this._matchAll != temp._matchAll) {
                return false;
            }
            if (this._has_matchAll != temp._has_matchAll) {
                return false;
            }
            if (this._emailAddressCommand != null) {
                if (temp._emailAddressCommand == null) {
                    return false;
                }
                if (!this._emailAddressCommand.equals(temp._emailAddressCommand)) {
                    return false;
                }
            } else if (temp._emailAddressCommand != null) {
                return false;
            }
            if (this._numericSkipResolutionPrefix != temp._numericSkipResolutionPrefix) {
                return false;
            }
            if (this._has_numericSkipResolutionPrefix != temp._has_numericSkipResolutionPrefix) {
                return false;
            }
            if (this._autoAcknowledgeAlarm != null) {
                if (temp._autoAcknowledgeAlarm == null) {
                    return false;
                }
                if (!this._autoAcknowledgeAlarm.equals(temp._autoAcknowledgeAlarm)) {
                    return false;
                }
            } else if (temp._autoAcknowledgeAlarm != null) {
                return false;
            }
            if (this._autoAcknowledgeList != null) {
                if (temp._autoAcknowledgeList == null) {
                    return false;
                }
                if (!this._autoAcknowledgeList.equals(temp._autoAcknowledgeList)) {
                    return false;
                }
            } else if (temp._autoAcknowledgeList != null) {
                return false;
            }
            if (this._queueList != null) {
                if (temp._queueList == null) {
                    return false;
                }
                if (!this._queueList.equals(temp._queueList)) {
                    return false;
                }
            } else if (temp._queueList != null) {
                return false;
            }
            if (this._outageCalendarList != null) {
                if (temp._outageCalendarList == null) {
                    return false;
                }
                if (!this._outageCalendarList.equals(temp._outageCalendarList)) {
                    return false;
                }
            } else if (temp._outageCalendarList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAcknowledgeIdSql() {
        return this._acknowledgeIdSql;
    }

    public String getAcknowledgeUpdateSql() {
        return this._acknowledgeUpdateSql;
    }

    public AutoAcknowledge getAutoAcknowledge(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("getAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this._autoAcknowledgeList.size() - 1) + "]");
        }
        return this._autoAcknowledgeList.get(index);
    }

    public AutoAcknowledge[] getAutoAcknowledge() {
        AutoAcknowledge[] array = new AutoAcknowledge[]{};
        return this._autoAcknowledgeList.toArray(array);
    }

    public AutoAcknowledgeAlarm getAutoAcknowledgeAlarm() {
        return this._autoAcknowledgeAlarm;
    }

    public List<AutoAcknowledge> getAutoAcknowledgeCollection() {
        return this._autoAcknowledgeList;
    }

    public int getAutoAcknowledgeCount() {
        return this._autoAcknowledgeList.size();
    }

    public String getEmailAddressCommand() {
        return this._emailAddressCommand;
    }

    public boolean getMatchAll() {
        return this._matchAll;
    }

    public String getNextGroupId() {
        return this._nextGroupId;
    }

    public String getNextNotifId() {
        return this._nextNotifId;
    }

    public String getNextUserNotifId() {
        return this._nextUserNotifId;
    }

    public boolean getNumericSkipResolutionPrefix() {
        return this._numericSkipResolutionPrefix;
    }

    public String getOutageCalendar(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("getOutageCalendar: Index value '" + index + "' not in range [0.." + (this._outageCalendarList.size() - 1) + "]");
        }
        return this._outageCalendarList.get(index);
    }

    public String[] getOutageCalendar() {
        String[] array = new String[]{};
        return this._outageCalendarList.toArray(array);
    }

    public List<String> getOutageCalendarCollection() {
        return this._outageCalendarList;
    }

    public int getOutageCalendarCount() {
        return this._outageCalendarList.size();
    }

    public String getOutstandingNoticesSql() {
        return this._outstandingNoticesSql;
    }

    public String getPagesSent() {
        return this._pagesSent;
    }

    public Queue getQueue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._queueList.size()) {
            throw new IndexOutOfBoundsException("getQueue: Index value '" + index + "' not in range [0.." + (this._queueList.size() - 1) + "]");
        }
        return this._queueList.get(index);
    }

    public Queue[] getQueue() {
        Queue[] array = new Queue[]{};
        return this._queueList.toArray(array);
    }

    public List<Queue> getQueueCollection() {
        return this._queueList;
    }

    public int getQueueCount() {
        return this._queueList.size();
    }

    public String getServiceIdSql() {
        return this._serviceIdSql;
    }

    public String getStatus() {
        return this._status;
    }

    public boolean hasMatchAll() {
        return this._has_matchAll;
    }

    public boolean hasNumericSkipResolutionPrefix() {
        return this._has_numericSkipResolutionPrefix;
    }

    public int hashCode() {
        int result = 17;
        if (this._status != null) {
            result = 37 * result + this._status.hashCode();
        }
        if (this._pagesSent != null) {
            result = 37 * result + this._pagesSent.hashCode();
        }
        if (this._nextNotifId != null) {
            result = 37 * result + this._nextNotifId.hashCode();
        }
        if (this._nextUserNotifId != null) {
            result = 37 * result + this._nextUserNotifId.hashCode();
        }
        if (this._nextGroupId != null) {
            result = 37 * result + this._nextGroupId.hashCode();
        }
        if (this._serviceIdSql != null) {
            result = 37 * result + this._serviceIdSql.hashCode();
        }
        if (this._outstandingNoticesSql != null) {
            result = 37 * result + this._outstandingNoticesSql.hashCode();
        }
        if (this._acknowledgeIdSql != null) {
            result = 37 * result + this._acknowledgeIdSql.hashCode();
        }
        if (this._acknowledgeUpdateSql != null) {
            result = 37 * result + this._acknowledgeUpdateSql.hashCode();
        }
        result = 37 * result + (this._matchAll ? 0 : 1);
        if (this._emailAddressCommand != null) {
            result = 37 * result + this._emailAddressCommand.hashCode();
        }
        result = 37 * result + (this._numericSkipResolutionPrefix ? 0 : 1);
        if (this._autoAcknowledgeAlarm != null) {
            result = 37 * result + this._autoAcknowledgeAlarm.hashCode();
        }
        if (this._autoAcknowledgeList != null) {
            result = 37 * result + this._autoAcknowledgeList.hashCode();
        }
        if (this._queueList != null) {
            result = 37 * result + this._queueList.hashCode();
        }
        if (this._outageCalendarList != null) {
            result = 37 * result + this._outageCalendarList.hashCode();
        }
        return result;
    }

    public boolean isMatchAll() {
        return this._matchAll;
    }

    public boolean isNumericSkipResolutionPrefix() {
        return this._numericSkipResolutionPrefix;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<AutoAcknowledge> iterateAutoAcknowledge() {
        return this._autoAcknowledgeList.iterator();
    }

    public Iterator<String> iterateOutageCalendar() {
        return this._outageCalendarList.iterator();
    }

    public Iterator<Queue> iterateQueue() {
        return this._queueList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllAutoAcknowledge() {
        this._autoAcknowledgeList.clear();
    }

    public void removeAllOutageCalendar() {
        this._outageCalendarList.clear();
    }

    public void removeAllQueue() {
        this._queueList.clear();
    }

    public boolean removeAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) {
        boolean removed = this._autoAcknowledgeList.remove(vAutoAcknowledge);
        return removed;
    }

    public AutoAcknowledge removeAutoAcknowledgeAt(int index) {
        AutoAcknowledge obj = this._autoAcknowledgeList.remove(index);
        return obj;
    }

    public boolean removeOutageCalendar(String vOutageCalendar) {
        boolean removed = this._outageCalendarList.remove(vOutageCalendar);
        return removed;
    }

    public String removeOutageCalendarAt(int index) {
        String obj = this._outageCalendarList.remove(index);
        return obj;
    }

    public boolean removeQueue(Queue vQueue) {
        boolean removed = this._queueList.remove(vQueue);
        return removed;
    }

    public Queue removeQueueAt(int index) {
        Queue obj = this._queueList.remove(index);
        return obj;
    }

    public void setAcknowledgeIdSql(String acknowledgeIdSql) {
        this._acknowledgeIdSql = acknowledgeIdSql;
    }

    public void setAcknowledgeUpdateSql(String acknowledgeUpdateSql) {
        this._acknowledgeUpdateSql = acknowledgeUpdateSql;
    }

    public void setAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException("setAutoAcknowledge: Index value '" + index + "' not in range [0.." + (this._autoAcknowledgeList.size() - 1) + "]");
        }
        this._autoAcknowledgeList.set(index, vAutoAcknowledge);
    }

    public void setAutoAcknowledge(AutoAcknowledge[] vAutoAcknowledgeArray) {
        this._autoAcknowledgeList.clear();
        for (int i = 0; i < vAutoAcknowledgeArray.length; ++i) {
            this._autoAcknowledgeList.add(vAutoAcknowledgeArray[i]);
        }
    }

    public void setAutoAcknowledge(List<AutoAcknowledge> vAutoAcknowledgeList) {
        this._autoAcknowledgeList.clear();
        this._autoAcknowledgeList.addAll(vAutoAcknowledgeList);
    }

    public void setAutoAcknowledgeAlarm(AutoAcknowledgeAlarm autoAcknowledgeAlarm) {
        this._autoAcknowledgeAlarm = autoAcknowledgeAlarm;
    }

    public void setAutoAcknowledgeCollection(List<AutoAcknowledge> autoAcknowledgeList) {
        this._autoAcknowledgeList = autoAcknowledgeList;
    }

    public void setEmailAddressCommand(String emailAddressCommand) {
        this._emailAddressCommand = emailAddressCommand;
    }

    public void setMatchAll(boolean matchAll) {
        this._matchAll = matchAll;
        this._has_matchAll = true;
    }

    public void setNextGroupId(String nextGroupId) {
        this._nextGroupId = nextGroupId;
    }

    public void setNextNotifId(String nextNotifId) {
        this._nextNotifId = nextNotifId;
    }

    public void setNextUserNotifId(String nextUserNotifId) {
        this._nextUserNotifId = nextUserNotifId;
    }

    public void setNumericSkipResolutionPrefix(boolean numericSkipResolutionPrefix) {
        this._numericSkipResolutionPrefix = numericSkipResolutionPrefix;
        this._has_numericSkipResolutionPrefix = true;
    }

    public void setOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException("setOutageCalendar: Index value '" + index + "' not in range [0.." + (this._outageCalendarList.size() - 1) + "]");
        }
        this._outageCalendarList.set(index, vOutageCalendar);
    }

    public void setOutageCalendar(String[] vOutageCalendarArray) {
        this._outageCalendarList.clear();
        for (int i = 0; i < vOutageCalendarArray.length; ++i) {
            this._outageCalendarList.add(vOutageCalendarArray[i]);
        }
    }

    public void setOutageCalendar(List<String> vOutageCalendarList) {
        this._outageCalendarList.clear();
        this._outageCalendarList.addAll(vOutageCalendarList);
    }

    public void setOutageCalendarCollection(List<String> outageCalendarList) {
        this._outageCalendarList = outageCalendarList;
    }

    public void setOutstandingNoticesSql(String outstandingNoticesSql) {
        this._outstandingNoticesSql = outstandingNoticesSql;
    }

    public void setPagesSent(String pagesSent) {
        this._pagesSent = pagesSent;
    }

    public void setQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._queueList.size()) {
            throw new IndexOutOfBoundsException("setQueue: Index value '" + index + "' not in range [0.." + (this._queueList.size() - 1) + "]");
        }
        this._queueList.set(index, vQueue);
    }

    public void setQueue(Queue[] vQueueArray) {
        this._queueList.clear();
        for (int i = 0; i < vQueueArray.length; ++i) {
            this._queueList.add(vQueueArray[i]);
        }
    }

    public void setQueue(List<Queue> vQueueList) {
        this._queueList.clear();
        this._queueList.addAll(vQueueList);
    }

    public void setQueueCollection(List<Queue> queueList) {
        this._queueList = queueList;
    }

    public void setServiceIdSql(String serviceIdSql) {
        this._serviceIdSql = serviceIdSql;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public static NotifdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (NotifdConfiguration)Unmarshaller.unmarshal(NotifdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

