/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.config.mailtransporttest.SendmailHost;
import org.opennms.netmgt.config.mailtransporttest.SendmailMessage;
import org.opennms.netmgt.config.mailtransporttest.SendmailProtocol;
import org.opennms.netmgt.config.mailtransporttest.UserAuth;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="sendmail-test")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SendmailTest
implements Serializable {
    private static final long serialVersionUID = 8076651227806492951L;
    private static final JavamailProperty[] EMPTY_LIST_OF_JAVAMAIL_PROPERTIES = new JavamailProperty[0];
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="use-authentication")
    private Boolean m_useAuthentication;
    @XmlAttribute(name="use-jmta")
    private Boolean m_useJmta;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="sendmail-host")
    private SendmailHost m_sendmailHost;
    @XmlElement(name="sendmail-protocol")
    private SendmailProtocol m_sendmailProtocol;
    @XmlElement(name="sendmail-message")
    private SendmailMessage m_sendmailMessage;
    @XmlElement(name="user-auth")
    private UserAuth m_userAuth;

    public SendmailTest() {
    }

    public SendmailTest(Long attemptInternal, Boolean debug, Boolean useAuthentication, Boolean useJmta) {
        this.m_attemptInterval = attemptInternal;
        this.m_debug = debug;
        this.m_useAuthentication = useAuthentication;
        this.m_useJmta = useJmta;
    }

    public void addJavamailProperty(JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.add(javamailProperty);
    }

    public void addJavamailProperty(int index, JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.add(index, javamailProperty);
    }

    public void addJavamailProperty(String name, String value) {
        this.m_javamailProperties.add(new JavamailProperty(name, value));
    }

    public void deleteAttemptInterval() {
        this.m_attemptInterval = null;
    }

    public void deleteDebug() {
        this.m_debug = null;
    }

    public void deleteUseAuthentication() {
        this.m_userAuth = null;
    }

    public void deleteUseJmta() {
        this.m_useJmta = null;
    }

    public Enumeration<JavamailProperty> enumerateJavamailProperty() {
        return Collections.enumeration(this.m_javamailProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailTest) {
            SendmailTest temp = (SendmailTest)obj;
            if (this.m_debug != null) {
                if (temp.m_debug == null) {
                    return false;
                }
                if (!this.m_debug.equals(temp.m_debug)) {
                    return false;
                }
            } else if (temp.m_debug != null) {
                return false;
            }
            if (this.m_useAuthentication != null) {
                if (temp.m_useAuthentication == null) {
                    return false;
                }
                if (!this.m_useAuthentication.equals(temp.m_useAuthentication)) {
                    return false;
                }
            } else if (temp.m_useAuthentication != null) {
                return false;
            }
            if (this.m_useJmta != null) {
                if (temp.m_useJmta == null) {
                    return false;
                }
                if (!this.m_useJmta.equals(temp.m_useJmta)) {
                    return false;
                }
            } else if (temp.m_useJmta != null) {
                return false;
            }
            if (this.m_attemptInterval != null) {
                if (temp.m_attemptInterval == null) {
                    return false;
                }
                if (!this.m_attemptInterval.equals(temp.m_attemptInterval)) {
                    return false;
                }
            } else if (temp.m_attemptInterval != null) {
                return false;
            }
            if (this.m_javamailProperties != null) {
                if (temp.m_javamailProperties == null) {
                    return false;
                }
                if (!this.m_javamailProperties.equals(temp.m_javamailProperties)) {
                    return false;
                }
            } else if (temp.m_javamailProperties != null) {
                return false;
            }
            if (this.m_sendmailHost != null) {
                if (temp.m_sendmailHost == null) {
                    return false;
                }
                if (!this.m_sendmailHost.equals(temp.m_sendmailHost)) {
                    return false;
                }
            } else if (temp.m_sendmailHost != null) {
                return false;
            }
            if (this.m_sendmailProtocol != null) {
                if (temp.m_sendmailProtocol == null) {
                    return false;
                }
                if (!this.m_sendmailProtocol.equals(temp.m_sendmailProtocol)) {
                    return false;
                }
            } else if (temp.m_sendmailProtocol != null) {
                return false;
            }
            if (this.m_sendmailMessage != null) {
                if (temp.m_sendmailMessage == null) {
                    return false;
                }
                if (!this.m_sendmailMessage.equals(temp.m_sendmailMessage)) {
                    return false;
                }
            } else if (temp.m_sendmailMessage != null) {
                return false;
            }
            if (this.m_userAuth != null) {
                if (temp.m_userAuth == null) {
                    return false;
                }
                if (!this.m_userAuth.equals(temp.m_userAuth)) {
                    return false;
                }
            } else if (temp.m_userAuth != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 3000L : this.m_attemptInterval;
    }

    public Boolean getDebug() {
        return this.m_debug == null ? true : this.m_debug;
    }

    public JavamailProperty getJavamailProperty(int index) throws IndexOutOfBoundsException {
        return this.m_javamailProperties.get(index);
    }

    public JavamailProperty[] getJavamailProperty() {
        return this.m_javamailProperties.toArray(EMPTY_LIST_OF_JAVAMAIL_PROPERTIES);
    }

    public List<JavamailProperty> getJavamailPropertyCollection() {
        return new ArrayList<JavamailProperty>(this.m_javamailProperties);
    }

    public int getJavamailPropertyCount() {
        return this.m_javamailProperties.size();
    }

    public SendmailHost getSendmailHost() {
        return this.m_sendmailHost;
    }

    public SendmailMessage getSendmailMessage() {
        return this.m_sendmailMessage;
    }

    public SendmailProtocol getSendmailProtocol() {
        return this.m_sendmailProtocol;
    }

    public Boolean getUseAuthentication() {
        return this.m_useAuthentication == null ? false : this.m_useAuthentication;
    }

    public Boolean getUseJmta() {
        return this.m_useJmta == null ? true : this.m_useJmta;
    }

    public UserAuth getUserAuth() {
        return this.m_userAuth;
    }

    public boolean hasAttemptInterval() {
        return this.m_attemptInterval != null;
    }

    public boolean hasDebug() {
        return this.m_debug != null;
    }

    public boolean hasUseAuthentication() {
        return this.m_useAuthentication != null;
    }

    public boolean hasUseJmta() {
        return this.m_useJmta != null;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_debug != null) {
            result = 37 * result + this.m_debug.hashCode();
        }
        if (this.m_useAuthentication != null) {
            result = 37 * result + this.m_useAuthentication.hashCode();
        }
        if (this.m_useJmta != null) {
            result = 37 * result + this.m_useJmta.hashCode();
        }
        if (this.m_attemptInterval != null) {
            result = 37 * result + this.m_attemptInterval.hashCode();
        }
        if (this.m_javamailProperties != null) {
            result = 37 * result + this.m_javamailProperties.hashCode();
        }
        if (this.m_sendmailHost != null) {
            result = 37 * result + this.m_sendmailHost.hashCode();
        }
        if (this.m_sendmailProtocol != null) {
            result = 37 * result + this.m_sendmailProtocol.hashCode();
        }
        if (this.m_sendmailMessage != null) {
            result = 37 * result + this.m_sendmailMessage.hashCode();
        }
        if (this.m_userAuth != null) {
            result = 37 * result + this.m_userAuth.hashCode();
        }
        return result;
    }

    public Boolean isDebug() {
        return this.m_debug == null ? true : this.m_debug;
    }

    public Boolean isUseAuthentication() {
        return this.m_useAuthentication == null ? false : this.m_useAuthentication;
    }

    public Boolean isUseJmta() {
        return this.m_useJmta == null ? true : this.m_useJmta;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<JavamailProperty> iterateJavamailProperty() {
        return this.m_javamailProperties.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllJavamailProperty() {
        this.m_javamailProperties.clear();
    }

    public boolean removeJavamailProperty(JavamailProperty javamailProperty) {
        return this.m_javamailProperties.remove(javamailProperty);
    }

    public JavamailProperty removeJavamailPropertyAt(int index) {
        return this.m_javamailProperties.remove(index);
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public void setJavamailProperty(int index, JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.set(index, javamailProperty);
    }

    public void setJavamailProperty(JavamailProperty[] javamailProperties) {
        this.m_javamailProperties.clear();
        for (JavamailProperty prop : javamailProperties) {
            this.m_javamailProperties.add(prop);
        }
    }

    public void setJavamailProperty(List<JavamailProperty> javamailProperties) {
        if (javamailProperties != this.m_javamailProperties) {
            this.m_javamailProperties.clear();
            this.m_javamailProperties.addAll(javamailProperties);
        }
    }

    public void setJavamailPropertyCollection(List<JavamailProperty> javamailProperties) {
        this.m_javamailProperties = new ArrayList<JavamailProperty>(javamailProperties);
    }

    public void setSendmailHost(SendmailHost sendmailHost) {
        this.m_sendmailHost = sendmailHost;
    }

    public void setSendmailHost(String host, Long port) {
        this.m_sendmailHost = new SendmailHost(host, port);
    }

    public void setSendmailMessage(SendmailMessage sendmailMessage) {
        this.m_sendmailMessage = sendmailMessage;
    }

    public void setSendmailProtocol(SendmailProtocol sendmailProtocol) {
        this.m_sendmailProtocol = sendmailProtocol;
    }

    public void setUseAuthentication(Boolean useAuthentication) {
        this.m_useAuthentication = useAuthentication;
    }

    public void setUseJmta(Boolean useJmta) {
        this.m_useJmta = useJmta;
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = userAuth;
    }

    public void setUserAuth(String username, String password) {
        this.m_userAuth = new UserAuth(username, password);
    }

    public static SendmailTest unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SendmailTest)Unmarshaller.unmarshal(SendmailTest.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

