/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Section
implements Serializable {
    private String _sectionName;
    private List<String> _categoryList = new ArrayList<String>();

    public void addCategory(String vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(vCategory);
    }

    public void addCategory(int index, String vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(index, vCategory);
    }

    public Enumeration<String> enumerateCategory() {
        return Collections.enumeration(this._categoryList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Section) {
            Section temp = (Section)obj;
            if (this._sectionName != null) {
                if (temp._sectionName == null) {
                    return false;
                }
                if (!this._sectionName.equals(temp._sectionName)) {
                    return false;
                }
            } else if (temp._sectionName != null) {
                return false;
            }
            if (this._categoryList != null) {
                if (temp._categoryList == null) {
                    return false;
                }
                if (!this._categoryList.equals(temp._categoryList)) {
                    return false;
                }
            } else if (temp._categoryList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getCategory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._categoryList.size()) {
            throw new IndexOutOfBoundsException("getCategory: Index value '" + index + "' not in range [0.." + (this._categoryList.size() - 1) + "]");
        }
        return this._categoryList.get(index);
    }

    public String[] getCategory() {
        String[] array = new String[]{};
        return this._categoryList.toArray(array);
    }

    public List<String> getCategoryCollection() {
        return this._categoryList;
    }

    public int getCategoryCount() {
        return this._categoryList.size();
    }

    public String getSectionName() {
        return this._sectionName;
    }

    public int hashCode() {
        int result = 17;
        if (this._sectionName != null) {
            result = 37 * result + this._sectionName.hashCode();
        }
        if (this._categoryList != null) {
            result = 37 * result + this._categoryList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateCategory() {
        return this._categoryList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllCategory() {
        this._categoryList.clear();
    }

    public boolean removeCategory(String vCategory) {
        boolean removed = this._categoryList.remove(vCategory);
        return removed;
    }

    public String removeCategoryAt(int index) {
        String obj = this._categoryList.remove(index);
        return obj;
    }

    public void setCategory(int index, String vCategory) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._categoryList.size()) {
            throw new IndexOutOfBoundsException("setCategory: Index value '" + index + "' not in range [0.." + (this._categoryList.size() - 1) + "]");
        }
        this._categoryList.set(index, vCategory);
    }

    public void setCategory(String[] vCategoryArray) {
        this._categoryList.clear();
        for (int i = 0; i < vCategoryArray.length; ++i) {
            this._categoryList.add(vCategoryArray[i]);
        }
    }

    public void setCategory(List<String> vCategoryList) {
        this._categoryList.clear();
        this._categoryList.addAll(vCategoryList);
    }

    public void setCategoryCollection(List<String> categoryList) {
        this._categoryList = categoryList;
    }

    public void setSectionName(String sectionName) {
        this._sectionName = sectionName;
    }

    public static Section unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Section)Unmarshaller.unmarshal(Section.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

