/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.ami.Definition;

@XmlRootElement(name="ami-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AmiConfig
implements Serializable {
    private static final long serialVersionUID = -7864880053573062376L;
    @XmlAttribute(name="port")
    private Integer _port;
    @XmlAttribute(name="use-ssl")
    private Boolean _useSsl;
    @XmlAttribute(name="timeout")
    private Integer _timeout;
    @XmlAttribute(name="retry")
    private Integer _retry;
    @XmlAttribute(name="username")
    private String _username;
    @XmlAttribute(name="password")
    private String _password;
    @XmlElement(name="definition")
    private List<Definition> _definitionList = new ArrayList<Definition>(0);

    public AmiConfig() {
    }

    public AmiConfig(int port, boolean useSsl, int timeout, int retry, String username, String password, List<Definition> definitions) {
        this.setPort(port);
        this.setUseSsl(useSsl);
        this.setTimeout(timeout);
        this.setRetry(retry);
        this.setUsername(username);
        this.setPassword(password);
        this.setDefinition(definitions);
    }

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public Enumeration<Definition> enumerateDefinition() {
        return Collections.enumeration(this._definitionList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmiConfig other = (AmiConfig)obj;
        if (this._definitionList == null ? other._definitionList != null : !this._definitionList.equals(other._definitionList)) {
            return false;
        }
        if (this._password == null ? other._password != null : !this._password.equals(other._password)) {
            return false;
        }
        if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
            return false;
        }
        if (this._retry == null ? other._retry != null : !this._retry.equals(other._retry)) {
            return false;
        }
        if (this._timeout == null ? other._timeout != null : !this._timeout.equals(other._timeout)) {
            return false;
        }
        if (this._useSsl == null ? other._useSsl != null : !this._useSsl.equals(other._useSsl)) {
            return false;
        }
        return !(this._username == null ? other._username != null : !this._username.equals(other._username));
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("getDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        return this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        Definition[] array = new Definition[]{};
        return this._definitionList.toArray(array);
    }

    public List<Definition> getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port == null ? 5038 : this._port;
    }

    public int getRetry() {
        return this._retry == null ? 0 : this._retry;
    }

    public int getTimeout() {
        return this._timeout == null ? 3000 : this._timeout;
    }

    public boolean getUseSsl() {
        return this._useSsl == null ? false : this._useSsl;
    }

    public String getUsername() {
        return this._username;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._definitionList == null ? 0 : this._definitionList.hashCode());
        result = 31 * result + (this._password == null ? 0 : this._password.hashCode());
        result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
        result = 31 * result + (this._retry == null ? 0 : this._retry.hashCode());
        result = 31 * result + (this._timeout == null ? 0 : this._timeout.hashCode());
        result = 31 * result + (this._useSsl == null ? 0 : this._useSsl.hashCode());
        result = 31 * result + (this._username == null ? 0 : this._username.hashCode());
        return result;
    }

    public boolean isUseSsl() {
        return this._useSsl;
    }

    public Iterator<Definition> iterateDefinition() {
        return this._definitionList.iterator();
    }

    public void removeAllDefinition() {
        this._definitionList.clear();
    }

    public boolean removeDefinition(Definition vDefinition) {
        return this._definitionList.remove(vDefinition);
    }

    public Definition removeDefinitionAt(int index) {
        return this._definitionList.remove(index);
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("setDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] vDefinitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < vDefinitionArray.length; ++i) {
            this._definitionList.add(vDefinitionArray[i]);
        }
    }

    public void setDefinition(List<Definition> vDefinitionList) {
        this._definitionList.clear();
        this._definitionList.addAll(vDefinitionList);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setRetry(int retry) {
        this._retry = retry;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setUseSsl(boolean useSsl) {
        this._useSsl = useSsl;
    }

    public void setUsername(String username) {
        this._username = username;
    }
}

