/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.ami.Range;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Definition
implements Serializable {
    private static final long serialVersionUID = -5866885462906545340L;
    @XmlAttribute(name="port")
    private Integer _port;
    @XmlAttribute(name="use-ssl")
    private Boolean _useSsl;
    @XmlAttribute(name="timeout")
    private Integer _timeout;
    @XmlAttribute(name="retry")
    private Integer _retry;
    @XmlAttribute(name="username")
    private String _username;
    @XmlAttribute(name="password")
    private String _password;
    @XmlElement(name="range")
    private List<Range> _rangeList = new ArrayList<Range>(0);
    @XmlElement(name="specific")
    private List<String> _specificList = new ArrayList<String>(0);
    @XmlElement(name="ip-match")
    private List<String> _ipMatchList = new ArrayList<String>(0);

    public Definition() {
    }

    public Definition(int port, boolean useSsl, int timeout, int retry, String username, String password, List<Range> ranges, List<String> specifics, List<String> ipMatches) {
        this.setPort(port);
        this.setUseSsl(useSsl);
        this.setTimeout(timeout);
        this.setRetry(retry);
        this.setUsername(username);
        this.setPassword(password);
        this.setRange(ranges);
        this.setSpecific(specifics);
        this.setIpMatch(ipMatches);
    }

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public Enumeration<String> enumerateIpMatch() {
        return Collections.enumeration(this._ipMatchList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this._rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Definition other = (Definition)obj;
        if (this._ipMatchList == null ? other._ipMatchList != null : !this._ipMatchList.equals(other._ipMatchList)) {
            return false;
        }
        if (this._password == null ? other._password != null : !this._password.equals(other._password)) {
            return false;
        }
        if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
            return false;
        }
        if (this._rangeList == null ? other._rangeList != null : !this._rangeList.equals(other._rangeList)) {
            return false;
        }
        if (this._retry == null ? other._retry != null : !this._retry.equals(other._retry)) {
            return false;
        }
        if (this._specificList == null ? other._specificList != null : !this._specificList.equals(other._specificList)) {
            return false;
        }
        if (this._timeout == null ? other._timeout != null : !this._timeout.equals(other._timeout)) {
            return false;
        }
        if (this._useSsl == null ? other._useSsl != null : !this._useSsl.equals(other._useSsl)) {
            return false;
        }
        return !(this._username == null ? other._username != null : !this._username.equals(other._username));
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("getIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        return this._ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        String[] array = new String[]{};
        return this._ipMatchList.toArray(array);
    }

    public List<String> getIpMatchCollection() {
        return this._ipMatchList;
    }

    public Integer getIpMatchCount() {
        return this._ipMatchList.size();
    }

    public String getPassword() {
        return this._password;
    }

    public Integer getPort() {
        return this._port;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        return this._rangeList.get(index);
    }

    public Range[] getRange() {
        Range[] array = new Range[]{};
        return this._rangeList.toArray(array);
    }

    public List<Range> getRangeCollection() {
        return this._rangeList;
    }

    public Integer getRangeCount() {
        return this._rangeList.size();
    }

    public Integer getRetry() {
        return this._retry;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public String[] getSpecific() {
        String[] array = new String[]{};
        return this._specificList.toArray(array);
    }

    public List<String> getSpecificCollection() {
        return this._specificList;
    }

    public Integer getSpecificCount() {
        return this._specificList.size();
    }

    public Integer getTimeout() {
        return this._timeout;
    }

    public boolean getUseSsl() {
        return this._useSsl == null ? false : this._useSsl;
    }

    public String getUsername() {
        return this._username;
    }

    public boolean hasPort() {
        return this._port != null;
    }

    public boolean hasRetry() {
        return this._retry != null;
    }

    public boolean hasTimeout() {
        return this._timeout != null;
    }

    public boolean hasUseSsl() {
        return this._useSsl != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._ipMatchList == null ? 0 : this._ipMatchList.hashCode());
        result = 31 * result + (this._password == null ? 0 : this._password.hashCode());
        result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
        result = 31 * result + (this._rangeList == null ? 0 : this._rangeList.hashCode());
        result = 31 * result + (this._retry == null ? 0 : this._retry.hashCode());
        result = 31 * result + (this._specificList == null ? 0 : this._specificList.hashCode());
        result = 31 * result + (this._timeout == null ? 0 : this._timeout.hashCode());
        result = 31 * result + (this._useSsl == null ? 0 : this._useSsl.hashCode());
        result = 31 * result + (this._username == null ? 0 : this._username.hashCode());
        return result;
    }

    public boolean isUseSsl() {
        return this._useSsl == null ? false : this._useSsl;
    }

    public Iterator<String> iterateIpMatch() {
        return this._ipMatchList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this._rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this._specificList.iterator();
    }

    public void removeAllIpMatch() {
        this._ipMatchList.clear();
    }

    public void removeAllRange() {
        this._rangeList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeIpMatch(String vIpMatch) {
        return this._ipMatchList.remove(vIpMatch);
    }

    public String removeIpMatchAt(int index) {
        return this._ipMatchList.remove(index);
    }

    public boolean removeRange(Range vRange) {
        return this._rangeList.remove(vRange);
    }

    public Range removeRangeAt(int index) {
        return this._rangeList.remove(index);
    }

    public boolean removeSpecific(String vSpecific) {
        return this._specificList.remove(vSpecific);
    }

    public String removeSpecificAt(int index) {
        return this._specificList.remove(index);
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("setIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        this._ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] vIpMatchArray) {
        this._ipMatchList.clear();
        for (int i = 0; i < vIpMatchArray.length; ++i) {
            this._ipMatchList.add(vIpMatchArray[i]);
        }
    }

    public void setIpMatch(List<String> vIpMatchList) {
        this._ipMatchList.clear();
        this._ipMatchList.addAll(vIpMatchList);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this._rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this._rangeList.clear();
        this._rangeList.addAll(vRangeList);
    }

    public void setRetry(int retry) {
        this._retry = retry;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setUseSsl(boolean useSsl) {
        this._useSsl = useSsl;
    }

    public void setUsername(String username) {
        this._username = username;
    }
}

