/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Autoacknowledge;
import org.opennms.netmgt.xml.eventconf.Autoaction;
import org.opennms.netmgt.xml.eventconf.Correlation;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.EventMatchers;
import org.opennms.netmgt.xml.eventconf.EventOrdering;
import org.opennms.netmgt.xml.eventconf.Filters;
import org.opennms.netmgt.xml.eventconf.Forward;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Operaction;
import org.opennms.netmgt.xml.eventconf.Script;
import org.opennms.netmgt.xml.eventconf.Snmp;
import org.opennms.netmgt.xml.eventconf.Tticket;
import org.opennms.netmgt.xml.eventconf.Varbindsdecode;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={})
public class Event
implements Serializable,
Comparable<Event> {
    private static final long serialVersionUID = 565808183599950549L;
    private static final Varbindsdecode[] EMPTY_VARBINDSDECODE_ARRAY = new Varbindsdecode[0];
    private static final Script[] EMPTY_SCRIPT_ARRAY = new Script[0];
    private static final Operaction[] EMPTY_OPERACTION_ARRAY = new Operaction[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Forward[] EMPTY_FORWARD_ARRAY = new Forward[0];
    private static final Autoaction[] EMPTY_AUTOACTION_ARRAY = new Autoaction[0];
    @XmlElement(name="mask", required=false)
    private Mask m_mask;
    @XmlElement(name="uei", required=true)
    private String m_uei;
    @XmlElement(name="event-label", required=true)
    private String m_eventLabel;
    @XmlElement(name="snmp", required=false)
    private Snmp m_snmp;
    @XmlElement(name="descr", required=true)
    private String m_descr;
    @XmlElement(name="logmsg", required=true)
    private Logmsg m_logmsg;
    @XmlElement(name="severity", required=true)
    private String m_severity;
    @XmlElement(name="correlation", required=false)
    private Correlation m_correlation;
    @XmlElement(name="operinstruct", required=false)
    private String m_operinstruct;
    @XmlElement(name="autoaction", required=false)
    private List<Autoaction> m_autoactions = new ArrayList<Autoaction>();
    @XmlElement(name="varbindsdecode", required=false)
    private List<Varbindsdecode> m_varbindsdecodes = new ArrayList<Varbindsdecode>();
    @XmlElement(name="operaction", required=false)
    private List<Operaction> m_operactions = new ArrayList<Operaction>();
    @XmlElement(name="autoacknowledge", required=false)
    private Autoacknowledge m_autoacknowledge;
    @XmlElement(name="loggroup", required=false)
    private List<String> m_loggroups = new ArrayList<String>();
    @XmlElement(name="tticket", required=false)
    private Tticket m_tticket;
    @XmlElement(name="forward", required=false)
    private List<Forward> m_forwards = new ArrayList<Forward>();
    @XmlElement(name="script", required=false)
    private List<Script> m_scripts = new ArrayList<Script>();
    @XmlElement(name="mouseovertext", required=false)
    private String m_mouseovertext;
    @XmlElement(name="alarm-data", required=false)
    private AlarmData m_alarmData;
    @XmlElement(name="filters", required=false)
    private Filters m_filters;
    @XmlTransient
    private EventMatcher m_matcher;
    @XmlTransient
    private EventOrdering.EventOrderIndex m_index;

    public EventOrdering.EventOrderIndex getIndex() {
        return this.m_index;
    }

    public void setIndex(EventOrdering.EventOrderIndex index) {
        this.m_index = index;
    }

    public void addAutoaction(Autoaction autoaction) throws IndexOutOfBoundsException {
        this.m_autoactions.add(autoaction);
    }

    public void addAutoaction(int index, Autoaction autoaction) throws IndexOutOfBoundsException {
        this.m_autoactions.add(index, autoaction);
    }

    public void addForward(Forward forward) throws IndexOutOfBoundsException {
        this.m_forwards.add(forward);
    }

    public void addForward(int index, Forward forward) throws IndexOutOfBoundsException {
        this.m_forwards.add(index, forward);
    }

    public void addLoggroup(String loggroup) throws IndexOutOfBoundsException {
        this.m_loggroups.add(loggroup.intern());
    }

    public void addLoggroup(int index, String loggroup) throws IndexOutOfBoundsException {
        this.m_loggroups.add(index, loggroup.intern());
    }

    public void addOperaction(Operaction operaction) throws IndexOutOfBoundsException {
        this.m_operactions.add(operaction);
    }

    public void addOperaction(int index, Operaction operaction) throws IndexOutOfBoundsException {
        this.m_operactions.add(index, operaction);
    }

    public void addScript(Script script) throws IndexOutOfBoundsException {
        this.m_scripts.add(script);
    }

    public void addScript(int index, Script script) throws IndexOutOfBoundsException {
        this.m_scripts.add(index, script);
    }

    public void addVarbindsdecode(Varbindsdecode varbindsdecode) throws IndexOutOfBoundsException {
        this.m_varbindsdecodes.add(varbindsdecode);
    }

    public void addVarbindsdecode(int index, Varbindsdecode varbindsdecode) throws IndexOutOfBoundsException {
        this.m_varbindsdecodes.add(index, varbindsdecode);
    }

    public Enumeration<Autoaction> enumerateAutoaction() {
        return Collections.enumeration(this.m_autoactions);
    }

    public Enumeration<Forward> enumerateForward() {
        return Collections.enumeration(this.m_forwards);
    }

    public Enumeration<String> enumerateLoggroup() {
        return Collections.enumeration(this.m_loggroups);
    }

    public Enumeration<Operaction> enumerateOperaction() {
        return Collections.enumeration(this.m_operactions);
    }

    public Enumeration<Script> enumerateScript() {
        return Collections.enumeration(this.m_scripts);
    }

    public Enumeration<Varbindsdecode> enumerateVarbindsdecode() {
        return Collections.enumeration(this.m_varbindsdecodes);
    }

    public AlarmData getAlarmData() {
        return this.m_alarmData;
    }

    public Autoacknowledge getAutoacknowledge() {
        return this.m_autoacknowledge;
    }

    public Autoaction getAutoaction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_autoactions.size()) {
            throw new IndexOutOfBoundsException("getAutoaction: Index value '" + index + "' not in range [0.." + (this.m_autoactions.size() - 1) + "]");
        }
        return this.m_autoactions.get(index);
    }

    public Autoaction[] getAutoaction() {
        return this.m_autoactions.toArray(EMPTY_AUTOACTION_ARRAY);
    }

    public List<Autoaction> getAutoactionCollection() {
        return this.m_autoactions;
    }

    public int getAutoactionCount() {
        return this.m_autoactions.size();
    }

    public Correlation getCorrelation() {
        return this.m_correlation;
    }

    public String getDescr() {
        return this.m_descr;
    }

    public String getEventLabel() {
        return this.m_eventLabel;
    }

    public Forward getForward(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_forwards.size()) {
            throw new IndexOutOfBoundsException("getForward: Index value '" + index + "' not in range [0.." + (this.m_forwards.size() - 1) + "]");
        }
        return this.m_forwards.get(index);
    }

    public Filters getFilters() {
        return this.m_filters;
    }

    public Forward[] getForward() {
        return this.m_forwards.toArray(EMPTY_FORWARD_ARRAY);
    }

    public List<Forward> getForwardCollection() {
        return this.m_forwards;
    }

    public int getForwardCount() {
        return this.m_forwards.size();
    }

    public String getLoggroup(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_loggroups.size()) {
            throw new IndexOutOfBoundsException("getLoggroup: Index value '" + index + "' not in range [0.." + (this.m_loggroups.size() - 1) + "]");
        }
        return this.m_loggroups.get(index);
    }

    public String[] getLoggroup() {
        return this.m_loggroups.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getLoggroupCollection() {
        return this.m_loggroups;
    }

    public int getLoggroupCount() {
        return this.m_loggroups.size();
    }

    public Logmsg getLogmsg() {
        return this.m_logmsg;
    }

    public Mask getMask() {
        return this.m_mask;
    }

    public String getMouseovertext() {
        return this.m_mouseovertext;
    }

    public Operaction getOperaction(int index) throws IndexOutOfBoundsException {
        return this.m_operactions.get(index);
    }

    public Operaction[] getOperaction() {
        return this.m_operactions.toArray(EMPTY_OPERACTION_ARRAY);
    }

    public List<Operaction> getOperactionCollection() {
        return this.m_operactions;
    }

    public int getOperactionCount() {
        return this.m_operactions.size();
    }

    public String getOperinstruct() {
        return this.m_operinstruct;
    }

    public Script getScript(int index) throws IndexOutOfBoundsException {
        return this.m_scripts.get(index);
    }

    public Script[] getScript() {
        return this.m_scripts.toArray(EMPTY_SCRIPT_ARRAY);
    }

    public List<Script> getScriptCollection() {
        return this.m_scripts;
    }

    public int getScriptCount() {
        return this.m_scripts.size();
    }

    public String getSeverity() {
        return this.m_severity;
    }

    public Snmp getSnmp() {
        return this.m_snmp;
    }

    public Tticket getTticket() {
        return this.m_tticket;
    }

    public String getUei() {
        return this.m_uei;
    }

    public Varbindsdecode getVarbindsdecode(int index) throws IndexOutOfBoundsException {
        return this.m_varbindsdecodes.get(index);
    }

    public Varbindsdecode[] getVarbindsdecode() {
        return this.m_varbindsdecodes.toArray(EMPTY_VARBINDSDECODE_ARRAY);
    }

    public List<Varbindsdecode> getVarbindsdecodeCollection() {
        return this.m_varbindsdecodes;
    }

    public int getVarbindsdecodeCount() {
        return this.m_varbindsdecodes.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Autoaction> iterateAutoaction() {
        return this.m_autoactions.iterator();
    }

    public Iterator<Forward> iterateForward() {
        return this.m_forwards.iterator();
    }

    public Iterator<String> iterateLoggroup() {
        return this.m_loggroups.iterator();
    }

    public Iterator<Operaction> iterateOperaction() {
        return this.m_operactions.iterator();
    }

    public Iterator<Script> iterateScript() {
        return this.m_scripts.iterator();
    }

    public Iterator<Varbindsdecode> iterateVarbindsdecode() {
        return this.m_varbindsdecodes.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllAutoaction() {
        this.m_autoactions.clear();
    }

    public void removeAllForward() {
        this.m_forwards.clear();
    }

    public void removeAllLoggroup() {
        this.m_loggroups.clear();
    }

    public void removeAllOperaction() {
        this.m_operactions.clear();
    }

    public void removeAllScript() {
        this.m_scripts.clear();
    }

    public void removeAllVarbindsdecode() {
        this.m_varbindsdecodes.clear();
    }

    public boolean removeAutoaction(Autoaction autoaction) {
        return this.m_autoactions.remove(autoaction);
    }

    public Autoaction removeAutoactionAt(int index) {
        return this.m_autoactions.remove(index);
    }

    public boolean removeForward(Forward forward) {
        return this.m_forwards.remove(forward);
    }

    public Forward removeForwardAt(int index) {
        return this.m_forwards.remove(index);
    }

    public boolean removeLoggroup(String loggroup) {
        return this.m_loggroups.remove(loggroup);
    }

    public String removeLoggroupAt(int index) {
        return this.m_loggroups.remove(index);
    }

    public boolean removeOperaction(Operaction operaction) {
        return this.m_operactions.remove(operaction);
    }

    public Operaction removeOperactionAt(int index) {
        return this.m_operactions.remove(index);
    }

    public boolean removeScript(Script script) {
        return this.m_scripts.remove(script);
    }

    public Script removeScriptAt(int index) {
        return this.m_scripts.remove(index);
    }

    public boolean removeVarbindsdecode(Varbindsdecode decode) {
        return this.m_varbindsdecodes.remove(decode);
    }

    public Varbindsdecode removeVarbindsdecodeAt(int index) {
        return this.m_varbindsdecodes.remove(index);
    }

    public void setAlarmData(AlarmData alarmData) {
        this.m_alarmData = alarmData;
    }

    public void setAutoacknowledge(Autoacknowledge autoacknowledge) {
        this.m_autoacknowledge = autoacknowledge;
    }

    public void setAutoaction(int index, Autoaction autoaction) throws IndexOutOfBoundsException {
        this.m_autoactions.set(index, autoaction);
    }

    public void setAutoaction(Autoaction[] autoactions) {
        this.m_autoactions.clear();
        for (Autoaction act : autoactions) {
            this.m_autoactions.add(act);
        }
    }

    public void setAutoaction(List<Autoaction> autoactions) {
        if (this.m_autoactions == autoactions) {
            return;
        }
        this.m_autoactions.clear();
        this.m_autoactions.addAll(autoactions);
    }

    public void setAutoactionCollection(List<Autoaction> autoactions) {
        this.setAutoaction(autoactions);
    }

    public void setCorrelation(Correlation correlation) {
        this.m_correlation = correlation;
    }

    public void setDescr(String descr) {
        this.m_descr = descr.intern();
    }

    public void setEventLabel(String eventLabel) {
        this.m_eventLabel = eventLabel.intern();
    }

    public void setFilters(Filters filters) {
        this.m_filters = filters;
    }

    public void setForward(int index, Forward forward) throws IndexOutOfBoundsException {
        this.m_forwards.set(index, forward);
    }

    public void setForward(Forward[] forwards) {
        this.m_forwards.clear();
        for (Forward forward : forwards) {
            this.m_forwards.add(forward);
        }
    }

    public void setForward(List<Forward> forwards) {
        if (this.m_forwards == forwards) {
            return;
        }
        this.m_forwards.clear();
        this.m_forwards.addAll(forwards);
    }

    public void setForwardCollection(List<Forward> forwards) {
        this.setForward(forwards);
    }

    public void setLoggroup(int index, String loggroup) throws IndexOutOfBoundsException {
        this.m_loggroups.set(index, loggroup.intern());
    }

    public void setLoggroup(String[] loggroups) {
        this.m_loggroups.clear();
        for (String group : loggroups) {
            this.m_loggroups.add(group.intern());
        }
    }

    public void setLoggroup(List<String> loggroups) {
        if (this.m_loggroups == loggroups) {
            return;
        }
        this.m_loggroups.clear();
        this.m_loggroups.addAll(loggroups);
    }

    public void setLoggroupCollection(List<String> loggroups) {
        this.setLoggroup(loggroups);
    }

    public void setLogmsg(Logmsg logmsg) {
        this.m_logmsg = logmsg;
    }

    public void setMask(Mask mask) {
        this.m_mask = mask;
    }

    public void setMouseovertext(String mouseovertext) {
        this.m_mouseovertext = mouseovertext.intern();
    }

    public void setOperaction(int index, Operaction operaction) throws IndexOutOfBoundsException {
        this.m_operactions.set(index, operaction);
    }

    public void setOperaction(Operaction[] operactions) {
        this.m_operactions.clear();
        for (Operaction action : operactions) {
            this.m_operactions.add(action);
        }
    }

    public void setOperaction(List<Operaction> operactions) {
        if (this.m_operactions == operactions) {
            return;
        }
        this.m_operactions.clear();
        this.m_operactions.addAll(operactions);
    }

    public void setOperactionCollection(List<Operaction> operactions) {
        this.setOperaction(operactions);
    }

    public void setOperinstruct(String operinstruct) {
        this.m_operinstruct = operinstruct == null ? null : operinstruct.intern();
    }

    public void setScript(int index, Script script) throws IndexOutOfBoundsException {
        this.m_scripts.set(index, script);
    }

    public void setScript(Script[] scripts) {
        this.m_scripts.clear();
        for (Script script : scripts) {
            this.m_scripts.add(script);
        }
    }

    public void setScript(List<Script> scripts) {
        if (this.m_scripts == scripts) {
            return;
        }
        this.m_scripts.clear();
        this.m_scripts.addAll(scripts);
    }

    public void setScriptCollection(List<Script> scripts) {
        this.setScript(scripts);
    }

    public void setSeverity(String severity) {
        this.m_severity = severity.intern();
    }

    public void setSnmp(Snmp snmp) {
        this.m_snmp = snmp;
    }

    public void setTticket(Tticket tticket) {
        this.m_tticket = tticket;
    }

    public void setUei(String uei) {
        this.m_uei = uei.intern();
    }

    public void setVarbindsdecode(int index, Varbindsdecode decode) throws IndexOutOfBoundsException {
        this.m_varbindsdecodes.set(index, decode);
    }

    public void setVarbindsdecode(Varbindsdecode[] decodes) {
        this.m_varbindsdecodes.clear();
        for (Varbindsdecode decode : decodes) {
            this.m_varbindsdecodes.add(decode);
        }
    }

    public void setVarbindsdecode(List<Varbindsdecode> decodes) {
        if (this.m_varbindsdecodes == decodes) {
            return;
        }
        this.m_varbindsdecodes.clear();
        this.m_varbindsdecodes.addAll(decodes);
    }

    public void setVarbindsdecodeCollection(List<Varbindsdecode> decodes) {
        this.setVarbindsdecode(decodes);
    }

    public static Event unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Event)Unmarshaller.unmarshal(Event.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_alarmData == null ? 0 : this.m_alarmData.hashCode());
        result = 31 * result + (this.m_autoacknowledge == null ? 0 : this.m_autoacknowledge.hashCode());
        result = 31 * result + (this.m_autoactions == null ? 0 : this.m_autoactions.hashCode());
        result = 31 * result + (this.m_correlation == null ? 0 : this.m_correlation.hashCode());
        result = 31 * result + (this.m_descr == null ? 0 : this.m_descr.hashCode());
        result = 31 * result + (this.m_eventLabel == null ? 0 : this.m_eventLabel.hashCode());
        result = 31 * result + (this.m_filters == null ? 0 : this.m_filters.hashCode());
        result = 31 * result + (this.m_forwards == null ? 0 : this.m_forwards.hashCode());
        result = 31 * result + (this.m_loggroups == null ? 0 : this.m_loggroups.hashCode());
        result = 31 * result + (this.m_logmsg == null ? 0 : this.m_logmsg.hashCode());
        result = 31 * result + (this.m_mask == null ? 0 : this.m_mask.hashCode());
        result = 31 * result + (this.m_mouseovertext == null ? 0 : this.m_mouseovertext.hashCode());
        result = 31 * result + (this.m_operactions == null ? 0 : this.m_operactions.hashCode());
        result = 31 * result + (this.m_operinstruct == null ? 0 : this.m_operinstruct.hashCode());
        result = 31 * result + (this.m_scripts == null ? 0 : this.m_scripts.hashCode());
        result = 31 * result + (this.m_severity == null ? 0 : this.m_severity.hashCode());
        result = 31 * result + (this.m_snmp == null ? 0 : this.m_snmp.hashCode());
        result = 31 * result + (this.m_tticket == null ? 0 : this.m_tticket.hashCode());
        result = 31 * result + (this.m_uei == null ? 0 : this.m_uei.hashCode());
        result = 31 * result + (this.m_varbindsdecodes == null ? 0 : this.m_varbindsdecodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (this.m_alarmData == null ? other.m_alarmData != null : !this.m_alarmData.equals(other.m_alarmData)) {
            return false;
        }
        if (this.m_autoacknowledge == null ? other.m_autoacknowledge != null : !this.m_autoacknowledge.equals(other.m_autoacknowledge)) {
            return false;
        }
        if (this.m_autoactions == null ? other.m_autoactions != null : !this.m_autoactions.equals(other.m_autoactions)) {
            return false;
        }
        if (this.m_correlation == null ? other.m_correlation != null : !this.m_correlation.equals(other.m_correlation)) {
            return false;
        }
        if (this.m_descr == null ? other.m_descr != null : !this.m_descr.equals(other.m_descr)) {
            return false;
        }
        if (this.m_eventLabel == null ? other.m_eventLabel != null : !this.m_eventLabel.equals(other.m_eventLabel)) {
            return false;
        }
        if (this.m_filters == null ? other.m_filters != null : !this.m_filters.equals(other.m_filters)) {
            return false;
        }
        if (this.m_forwards == null ? other.m_forwards != null : !this.m_forwards.equals(other.m_forwards)) {
            return false;
        }
        if (this.m_loggroups == null ? other.m_loggroups != null : !this.m_loggroups.equals(other.m_loggroups)) {
            return false;
        }
        if (this.m_logmsg == null ? other.m_logmsg != null : !this.m_logmsg.equals(other.m_logmsg)) {
            return false;
        }
        if (this.m_mask == null ? other.m_mask != null : !this.m_mask.equals(other.m_mask)) {
            return false;
        }
        if (this.m_mouseovertext == null ? other.m_mouseovertext != null : !this.m_mouseovertext.equals(other.m_mouseovertext)) {
            return false;
        }
        if (this.m_operactions == null ? other.m_operactions != null : !this.m_operactions.equals(other.m_operactions)) {
            return false;
        }
        if (this.m_operinstruct == null ? other.m_operinstruct != null : !this.m_operinstruct.equals(other.m_operinstruct)) {
            return false;
        }
        if (this.m_scripts == null ? other.m_scripts != null : !this.m_scripts.equals(other.m_scripts)) {
            return false;
        }
        if (this.m_severity == null ? other.m_severity != null : !this.m_severity.equals(other.m_severity)) {
            return false;
        }
        if (this.m_snmp == null ? other.m_snmp != null : !this.m_snmp.equals(other.m_snmp)) {
            return false;
        }
        if (this.m_tticket == null ? other.m_tticket != null : !this.m_tticket.equals(other.m_tticket)) {
            return false;
        }
        if (this.m_uei == null ? other.m_uei != null : !this.m_uei.equals(other.m_uei)) {
            return false;
        }
        return !(this.m_varbindsdecodes == null ? other.m_varbindsdecodes != null : !this.m_varbindsdecodes.equals(other.m_varbindsdecodes));
    }

    private EventMatcher constructMatcher() {
        if (this.m_mask == null || this.m_mask.getMaskelementCount() <= 0) {
            return this.m_uei == null ? EventMatchers.falseMatcher() : EventMatchers.ueiMatcher(this.m_uei);
        }
        return this.m_mask.constructMatcher();
    }

    public boolean matches(org.opennms.netmgt.xml.event.Event matchingEvent) {
        return this.m_matcher.matches(matchingEvent);
    }

    public void initialize(EventOrdering.EventOrderIndex eventOrderIndex) {
        this.m_index = eventOrderIndex;
        this.m_matcher = this.constructMatcher();
    }

    public List<String> getMaskElementValues(String mename) {
        return this.m_mask == null ? null : this.m_mask.getMaskElementValues(mename);
    }

    @Override
    public int compareTo(Event o) {
        return this.getIndex().compareTo(o.getIndex());
    }
}

