/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.Filter;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="filters")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
public class Filters
implements Serializable {
    private static final long serialVersionUID = 3672883849182860671L;
    private static final Filter[] EMPTY_FILTER_ARRAY = new Filter[0];
    @XmlElement(name="filter", required=true)
    private List<Filter> m_filters = new ArrayList<Filter>();

    public void addFilter(Filter filter) throws IndexOutOfBoundsException {
        this.m_filters.add(filter);
    }

    public void addFilter(int index, Filter filter) throws IndexOutOfBoundsException {
        this.m_filters.add(index, filter);
    }

    public Enumeration<Filter> enumerateFilter() {
        return Collections.enumeration(this.m_filters);
    }

    public Filter getFilter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_filters.size()) {
            throw new IndexOutOfBoundsException("getFilter: Index value '" + index + "' not in range [0.." + (this.m_filters.size() - 1) + "]");
        }
        return this.m_filters.get(index);
    }

    public Filter[] getFilter() {
        return this.m_filters.toArray(EMPTY_FILTER_ARRAY);
    }

    public List<Filter> getFilterCollection() {
        return this.m_filters;
    }

    public int getFilterCount() {
        return this.m_filters.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Filter> iterateFilter() {
        return this.m_filters.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllFilter() {
        this.m_filters.clear();
    }

    public boolean removeFilter(Filter filter) {
        return this.m_filters.remove(filter);
    }

    public Filter removeFilterAt(int index) {
        return this.m_filters.remove(index);
    }

    public void setFilter(int index, Filter filter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_filters.size()) {
            throw new IndexOutOfBoundsException("setFilter: Index value '" + index + "' not in range [0.." + (this.m_filters.size() - 1) + "]");
        }
        this.m_filters.set(index, filter);
    }

    public void setFilter(Filter[] filters) {
        this.m_filters.clear();
        for (Filter filter : filters) {
            this.m_filters.add(filter);
        }
    }

    public void setFilter(List<Filter> filters) {
        if (this.m_filters == filters) {
            return;
        }
        this.m_filters.clear();
        this.m_filters.addAll(filters);
    }

    public void setFilterCollection(List<Filter> filters) {
        this.setFilter(filters);
    }

    public static Filters unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Filters)Unmarshaller.unmarshal(Filters.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_filters == null ? 0 : this.m_filters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return !(this.m_filters == null ? other.m_filters != null : !this.m_filters.equals(other.m_filters));
    }
}

