/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.destinationPaths.Header;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.xml.sax.ContentHandler;

public class DestinationPaths
implements Serializable {
    private Header _header;
    private List<Path> _pathList = new ArrayList<Path>();

    public void addPath(Path vPath) throws IndexOutOfBoundsException {
        this._pathList.add(vPath);
    }

    public void addPath(int index, Path vPath) throws IndexOutOfBoundsException {
        this._pathList.add(index, vPath);
    }

    public Enumeration<Path> enumeratePath() {
        return Collections.enumeration(this._pathList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DestinationPaths) {
            DestinationPaths temp = (DestinationPaths)obj;
            if (this._header != null) {
                if (temp._header == null) {
                    return false;
                }
                if (!this._header.equals(temp._header)) {
                    return false;
                }
            } else if (temp._header != null) {
                return false;
            }
            if (this._pathList != null) {
                if (temp._pathList == null) {
                    return false;
                }
                if (!this._pathList.equals(temp._pathList)) {
                    return false;
                }
            } else if (temp._pathList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Header getHeader() {
        return this._header;
    }

    public Path getPath(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._pathList.size()) {
            throw new IndexOutOfBoundsException("getPath: Index value '" + index + "' not in range [0.." + (this._pathList.size() - 1) + "]");
        }
        return this._pathList.get(index);
    }

    public Path[] getPath() {
        Path[] array = new Path[]{};
        return this._pathList.toArray(array);
    }

    public List<Path> getPathCollection() {
        return this._pathList;
    }

    public int getPathCount() {
        return this._pathList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._header != null) {
            result = 37 * result + this._header.hashCode();
        }
        if (this._pathList != null) {
            result = 37 * result + this._pathList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Path> iteratePath() {
        return this._pathList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPath() {
        this._pathList.clear();
    }

    public boolean removePath(Path vPath) {
        boolean removed = this._pathList.remove(vPath);
        return removed;
    }

    public Path removePathAt(int index) {
        Path obj = this._pathList.remove(index);
        return obj;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setPath(int index, Path vPath) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._pathList.size()) {
            throw new IndexOutOfBoundsException("setPath: Index value '" + index + "' not in range [0.." + (this._pathList.size() - 1) + "]");
        }
        this._pathList.set(index, vPath);
    }

    public void setPath(Path[] vPathArray) {
        this._pathList.clear();
        for (int i = 0; i < vPathArray.length; ++i) {
            this._pathList.add(vPathArray[i]);
        }
    }

    public void setPath(List<Path> vPathList) {
        this._pathList.clear();
        this._pathList.addAll(vPathList);
    }

    public void setPathCollection(List<Path> pathList) {
        this._pathList = pathList;
    }

    public static DestinationPaths unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DestinationPaths)Unmarshaller.unmarshal(DestinationPaths.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

