/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.agents;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.xml.JaxbMapAdapter;

@XmlRootElement(name="agent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AgentResponse {
    @XmlElement(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_address;
    @XmlElement(name="port")
    private Integer m_port;
    @XmlElement(name="serviceName")
    private String m_serviceName;
    @XmlElement(name="parameters")
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    private Map<String, String> m_parameters = new HashMap<String, String>();

    public AgentResponse() {
    }

    public AgentResponse(InetAddress address, Integer port, String serviceName, Map<String, String> parameters) {
        this.m_address = address;
        this.m_port = port;
        this.m_serviceName = serviceName;
        this.m_parameters = parameters;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        return "AgentResponse [address=" + this.m_address + ", port=" + this.m_port + ", serviceName=" + this.m_serviceName + ", parameters=" + this.m_parameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_address == null ? 0 : this.m_address.hashCode());
        result = 31 * result + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        result = 31 * result + (this.m_port == null ? 0 : this.m_port.hashCode());
        result = 31 * result + (this.m_serviceName == null ? 0 : this.m_serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentResponse other = (AgentResponse)obj;
        if (this.m_address == null ? other.m_address != null : !this.m_address.equals(other.m_address)) {
            return false;
        }
        if (this.m_parameters == null ? other.m_parameters != null : !this.m_parameters.equals(other.m_parameters)) {
            return false;
        }
        if (this.m_port == null ? other.m_port != null : !this.m_port.equals(other.m_port)) {
            return false;
        }
        return !(this.m_serviceName == null ? other.m_serviceName != null : !this.m_serviceName.equals(other.m_serviceName));
    }
}

