/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.vacuumd.AutoEvent;

@XmlRootElement(name="auto-events")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AutoEvents
implements Serializable {
    private static final long serialVersionUID = 8553439381132405258L;
    @XmlElement(name="auto-event")
    private List<AutoEvent> _autoEventList = new ArrayList<AutoEvent>();

    public AutoEvents() {
    }

    public AutoEvents(List<AutoEvent> autoEvents) {
        this.setAutoEvent(autoEvents);
    }

    public void addAutoEvent(AutoEvent vAutoEvent) throws IndexOutOfBoundsException {
        this._autoEventList.add(vAutoEvent);
    }

    public void addAutoEvent(int index, AutoEvent vAutoEvent) throws IndexOutOfBoundsException {
        this._autoEventList.add(index, vAutoEvent);
    }

    public Enumeration<AutoEvent> enumerateAutoEvent() {
        return Collections.enumeration(this._autoEventList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutoEvents) {
            AutoEvents temp = (AutoEvents)obj;
            if (this._autoEventList != null) {
                if (temp._autoEventList == null) {
                    return false;
                }
                if (!this._autoEventList.equals(temp._autoEventList)) {
                    return false;
                }
            } else if (temp._autoEventList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public AutoEvent getAutoEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoEventList.size()) {
            throw new IndexOutOfBoundsException("getAutoEvent: Index value '" + index + "' not in range [0.." + (this._autoEventList.size() - 1) + "]");
        }
        return this._autoEventList.get(index);
    }

    public AutoEvent[] getAutoEvent() {
        AutoEvent[] array = new AutoEvent[]{};
        return this._autoEventList.toArray(array);
    }

    public List<AutoEvent> getAutoEventCollection() {
        return this._autoEventList;
    }

    public int getAutoEventCount() {
        return this._autoEventList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._autoEventList != null) {
            result = 37 * result + this._autoEventList.hashCode();
        }
        return result;
    }

    public Iterator<AutoEvent> iterateAutoEvent() {
        return this._autoEventList.iterator();
    }

    public void removeAllAutoEvent() {
        this._autoEventList.clear();
    }

    public boolean removeAutoEvent(AutoEvent vAutoEvent) {
        return this._autoEventList.remove(vAutoEvent);
    }

    public AutoEvent removeAutoEventAt(int index) {
        return this._autoEventList.remove(index);
    }

    public void setAutoEvent(int index, AutoEvent vAutoEvent) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._autoEventList.size()) {
            throw new IndexOutOfBoundsException("setAutoEvent: Index value '" + index + "' not in range [0.." + (this._autoEventList.size() - 1) + "]");
        }
        this._autoEventList.set(index, vAutoEvent);
    }

    public void setAutoEvent(AutoEvent[] vAutoEventArray) {
        this._autoEventList.clear();
        for (int i = 0; i < vAutoEventArray.length; ++i) {
            this._autoEventList.add(vAutoEventArray[i]);
        }
    }

    public void setAutoEvent(List<AutoEvent> vAutoEventList) {
        this._autoEventList.clear();
        this._autoEventList.addAll(vAutoEventList);
    }
}

