/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.translator.Mapping;
import org.xml.sax.ContentHandler;

public class Mappings
implements Serializable {
    private List<Mapping> _mappingList = new ArrayList<Mapping>();

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(index, vMapping);
    }

    public Enumeration<Mapping> enumerateMapping() {
        return Collections.enumeration(this._mappingList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mappings) {
            Mappings temp = (Mappings)obj;
            if (this._mappingList != null) {
                if (temp._mappingList == null) {
                    return false;
                }
                if (!this._mappingList.equals(temp._mappingList)) {
                    return false;
                }
            } else if (temp._mappingList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        return this._mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this._mappingList.toArray(array);
    }

    public List<Mapping> getMappingCollection() {
        return this._mappingList;
    }

    public int getMappingCount() {
        return this._mappingList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._mappingList != null) {
            result = 37 * result + this._mappingList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Mapping> iterateMapping() {
        return this._mappingList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMapping() {
        this._mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this._mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this._mappingList.remove(index);
        return obj;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        this._mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this._mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this._mappingList.add(vMappingArray[i]);
        }
    }

    public void setMapping(List<Mapping> vMappingList) {
        this._mappingList.clear();
        this._mappingList.addAll(vMappingList);
    }

    public void setMappingCollection(List<Mapping> mappingList) {
        this._mappingList = mappingList;
    }

    public static Mappings unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Mappings)Unmarshaller.unmarshal(Mappings.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

