/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.xml.sax.ContentHandler;

public class ProvisiondConfiguration
implements Serializable {
    private long _importThreads = 8L;
    private boolean _has_importThreads;
    private long _scanThreads = 10L;
    private boolean _has_scanThreads;
    private long _rescanThreads = 10L;
    private boolean _has_rescanThreads;
    private long _writeThreads = 8L;
    private boolean _has_writeThreads;
    private String _requistionDir = "${install.dir}/etc/imports";
    private String _foreignSourceDir = "${install.dir}/etc/foreign-sources";
    private List<RequisitionDef> _requisitionDefList;

    public ProvisiondConfiguration() {
        this.setRequistionDir("${install.dir}/etc/imports");
        this.setForeignSourceDir("${install.dir}/etc/foreign-sources");
        this._requisitionDefList = new ArrayList<RequisitionDef>();
    }

    public void addRequisitionDef(RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        this._requisitionDefList.add(vRequisitionDef);
    }

    public void addRequisitionDef(int index, RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        this._requisitionDefList.add(index, vRequisitionDef);
    }

    public void deleteImportThreads() {
        this._has_importThreads = false;
    }

    public void deleteRescanThreads() {
        this._has_rescanThreads = false;
    }

    public void deleteScanThreads() {
        this._has_scanThreads = false;
    }

    public void deleteWriteThreads() {
        this._has_writeThreads = false;
    }

    public Enumeration<RequisitionDef> enumerateRequisitionDef() {
        return Collections.enumeration(this._requisitionDefList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvisiondConfiguration) {
            ProvisiondConfiguration temp = (ProvisiondConfiguration)obj;
            if (this._importThreads != temp._importThreads) {
                return false;
            }
            if (this._has_importThreads != temp._has_importThreads) {
                return false;
            }
            if (this._scanThreads != temp._scanThreads) {
                return false;
            }
            if (this._has_scanThreads != temp._has_scanThreads) {
                return false;
            }
            if (this._rescanThreads != temp._rescanThreads) {
                return false;
            }
            if (this._has_rescanThreads != temp._has_rescanThreads) {
                return false;
            }
            if (this._writeThreads != temp._writeThreads) {
                return false;
            }
            if (this._has_writeThreads != temp._has_writeThreads) {
                return false;
            }
            if (this._requistionDir != null) {
                if (temp._requistionDir == null) {
                    return false;
                }
                if (!this._requistionDir.equals(temp._requistionDir)) {
                    return false;
                }
            } else if (temp._requistionDir != null) {
                return false;
            }
            if (this._foreignSourceDir != null) {
                if (temp._foreignSourceDir == null) {
                    return false;
                }
                if (!this._foreignSourceDir.equals(temp._foreignSourceDir)) {
                    return false;
                }
            } else if (temp._foreignSourceDir != null) {
                return false;
            }
            if (this._requisitionDefList != null) {
                if (temp._requisitionDefList == null) {
                    return false;
                }
                if (!this._requisitionDefList.equals(temp._requisitionDefList)) {
                    return false;
                }
            } else if (temp._requisitionDefList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getForeignSourceDir() {
        return this._foreignSourceDir;
    }

    public long getImportThreads() {
        return this._importThreads;
    }

    public RequisitionDef getRequisitionDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._requisitionDefList.size()) {
            throw new IndexOutOfBoundsException("getRequisitionDef: Index value '" + index + "' not in range [0.." + (this._requisitionDefList.size() - 1) + "]");
        }
        return this._requisitionDefList.get(index);
    }

    public RequisitionDef[] getRequisitionDef() {
        RequisitionDef[] array = new RequisitionDef[]{};
        return this._requisitionDefList.toArray(array);
    }

    public List<RequisitionDef> getRequisitionDefCollection() {
        return this._requisitionDefList;
    }

    public int getRequisitionDefCount() {
        return this._requisitionDefList.size();
    }

    public String getRequistionDir() {
        return this._requistionDir;
    }

    public long getRescanThreads() {
        return this._rescanThreads;
    }

    public long getScanThreads() {
        return this._scanThreads;
    }

    public long getWriteThreads() {
        return this._writeThreads;
    }

    public boolean hasImportThreads() {
        return this._has_importThreads;
    }

    public boolean hasRescanThreads() {
        return this._has_rescanThreads;
    }

    public boolean hasScanThreads() {
        return this._has_scanThreads;
    }

    public boolean hasWriteThreads() {
        return this._has_writeThreads;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this._importThreads ^ this._importThreads >>> 32);
        result = 37 * result + (int)(this._scanThreads ^ this._scanThreads >>> 32);
        result = 37 * result + (int)(this._rescanThreads ^ this._rescanThreads >>> 32);
        result = 37 * result + (int)(this._writeThreads ^ this._writeThreads >>> 32);
        if (this._requistionDir != null) {
            result = 37 * result + this._requistionDir.hashCode();
        }
        if (this._foreignSourceDir != null) {
            result = 37 * result + this._foreignSourceDir.hashCode();
        }
        if (this._requisitionDefList != null) {
            result = 37 * result + this._requisitionDefList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<RequisitionDef> iterateRequisitionDef() {
        return this._requisitionDefList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllRequisitionDef() {
        this._requisitionDefList.clear();
    }

    public boolean removeRequisitionDef(RequisitionDef vRequisitionDef) {
        boolean removed = this._requisitionDefList.remove(vRequisitionDef);
        return removed;
    }

    public RequisitionDef removeRequisitionDefAt(int index) {
        RequisitionDef obj = this._requisitionDefList.remove(index);
        return obj;
    }

    public void setForeignSourceDir(String foreignSourceDir) {
        this._foreignSourceDir = foreignSourceDir;
    }

    public void setImportThreads(long importThreads) {
        this._importThreads = importThreads;
        this._has_importThreads = true;
    }

    public void setRequisitionDef(int index, RequisitionDef vRequisitionDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._requisitionDefList.size()) {
            throw new IndexOutOfBoundsException("setRequisitionDef: Index value '" + index + "' not in range [0.." + (this._requisitionDefList.size() - 1) + "]");
        }
        this._requisitionDefList.set(index, vRequisitionDef);
    }

    public void setRequisitionDef(RequisitionDef[] vRequisitionDefArray) {
        this._requisitionDefList.clear();
        for (int i = 0; i < vRequisitionDefArray.length; ++i) {
            this._requisitionDefList.add(vRequisitionDefArray[i]);
        }
    }

    public void setRequisitionDef(List<RequisitionDef> vRequisitionDefList) {
        this._requisitionDefList.clear();
        this._requisitionDefList.addAll(vRequisitionDefList);
    }

    public void setRequisitionDefCollection(List<RequisitionDef> requisitionDefList) {
        this._requisitionDefList = requisitionDefList;
    }

    public void setRequistionDir(String requistionDir) {
        this._requistionDir = requistionDir;
    }

    public void setRescanThreads(long rescanThreads) {
        this._rescanThreads = rescanThreads;
        this._has_rescanThreads = true;
    }

    public void setScanThreads(long scanThreads) {
        this._scanThreads = scanThreads;
        this._has_scanThreads = true;
    }

    public void setWriteThreads(long writeThreads) {
        this._writeThreads = writeThreads;
        this._has_writeThreads = true;
    }

    public static ProvisiondConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ProvisiondConfiguration)Unmarshaller.unmarshal(ProvisiondConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

