/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;

@XmlRootElement(name="poller-configuration")
@ValidateUsing(value="poller-configuration.xsd")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={PageSequence.class})
public class PollerConfiguration
implements Serializable {
    private static final long serialVersionUID = 3402898044699865749L;
    @XmlAttribute(name="threads")
    private Integer m_threads = 30;
    @XmlAttribute(name="nextOutageId")
    private String m_nextOutageId = "SELECT nextval('outageNxtId')";
    @XmlAttribute(name="serviceUnresponsiveEnabled")
    private String m_serviceUnresponsiveEnabled = "false";
    @XmlAttribute(name="xmlrpc")
    private String m_xmlrpc = "false";
    @XmlAttribute(name="pathOutageEnabled")
    private String m_pathOutageEnabled = "false";
    @XmlElement(name="node-outage")
    private NodeOutage m_nodeOutage;
    @XmlElement(name="package")
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="monitor")
    private List<Monitor> m_monitors = new ArrayList<Monitor>();

    public Integer getThreads() {
        return this.m_threads == null ? 0 : this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = threads;
    }

    public String getNextOutageId() {
        return this.m_nextOutageId == null ? "SELECT nextval('outageNxtId')" : this.m_nextOutageId;
    }

    public void setNextOutageId(String nextOutageId) {
        this.m_nextOutageId = nextOutageId;
    }

    public String getServiceUnresponsiveEnabled() {
        return this.m_serviceUnresponsiveEnabled;
    }

    public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
        this.m_serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public String getXmlrpc() {
        return this.m_xmlrpc == null ? "false" : this.m_xmlrpc;
    }

    public void setXmlrpc(String xmlrpc) {
        this.m_xmlrpc = xmlrpc;
    }

    public String getPathOutageEnabled() {
        return this.m_pathOutageEnabled == null ? "false" : this.m_pathOutageEnabled;
    }

    public void setPathOutageEnabled(String pathOutageEnabled) {
        this.m_pathOutageEnabled = pathOutageEnabled;
    }

    public NodeOutage getNodeOutage() {
        return this.m_nodeOutage;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this.m_nodeOutage = nodeOutage;
    }

    public List<Package> getPackages() {
        if (this.m_packages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_packages);
    }

    public void setPackages(List<Package> packages) {
        this.m_packages = new ArrayList<Package>(packages);
    }

    public void addPackage(Package pack) throws IndexOutOfBoundsException {
        this.m_packages.add(pack);
    }

    public boolean removePackage(Package pack) {
        return this.m_packages.remove(pack);
    }

    public Package getPackage(String packageName) {
        for (Package pkg : this.m_packages) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public List<Monitor> getMonitors() {
        if (this.m_monitors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_monitors);
    }

    public void setMonitors(List<Monitor> monitors) {
        this.m_monitors = new ArrayList<Monitor>(monitors);
    }

    public void addMonitor(Monitor monitor) throws IndexOutOfBoundsException {
        this.m_monitors.add(monitor);
    }

    public void addMonitor(String service, String className) {
        this.addMonitor(new Monitor(service, className));
    }

    public boolean removeMonitor(Monitor monitor) {
        return this.m_monitors.remove(monitor);
    }

    public PollerConfiguration getPollerConfigurationForPackage(String pollingPackageName) {
        if (pollingPackageName == null) {
            return null;
        }
        Package pkg = this.getPackage(pollingPackageName);
        if (pkg == null) {
            return null;
        }
        HashSet<String> seenMonitors = new HashSet<String>();
        PollerConfiguration newConfig = new PollerConfiguration();
        newConfig.setThreads(this.getThreads());
        newConfig.setNextOutageId(this.getNextOutageId());
        newConfig.setServiceUnresponsiveEnabled(this.getServiceUnresponsiveEnabled());
        newConfig.setXmlrpc(this.getXmlrpc());
        newConfig.setPathOutageEnabled(this.getPathOutageEnabled());
        newConfig.setNodeOutage(this.getNodeOutage());
        newConfig.addPackage(pkg);
        for (Service service : pkg.getServices()) {
            seenMonitors.add(service.getName());
        }
        for (Monitor monitor : this.getMonitors()) {
            if (!seenMonitors.contains(monitor.getService())) continue;
            newConfig.addMonitor(monitor);
        }
        return newConfig;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_monitors == null ? 0 : this.m_monitors.hashCode());
        result = 31 * result + (this.m_nextOutageId == null ? 0 : this.m_nextOutageId.hashCode());
        result = 31 * result + (this.m_nodeOutage == null ? 0 : this.m_nodeOutage.hashCode());
        result = 31 * result + (this.m_packages == null ? 0 : this.m_packages.hashCode());
        result = 31 * result + (this.m_pathOutageEnabled == null ? 0 : this.m_pathOutageEnabled.hashCode());
        result = 31 * result + (this.m_serviceUnresponsiveEnabled == null ? 0 : this.m_serviceUnresponsiveEnabled.hashCode());
        result = 31 * result + (this.m_threads == null ? 0 : this.m_threads.hashCode());
        result = 31 * result + (this.m_xmlrpc == null ? 0 : this.m_xmlrpc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollerConfiguration)) {
            return false;
        }
        PollerConfiguration other = (PollerConfiguration)obj;
        if (this.m_monitors == null ? other.m_monitors != null : !this.m_monitors.equals(other.m_monitors)) {
            return false;
        }
        if (this.m_nextOutageId == null ? other.m_nextOutageId != null : !this.m_nextOutageId.equals(other.m_nextOutageId)) {
            return false;
        }
        if (this.m_nodeOutage == null ? other.m_nodeOutage != null : !this.m_nodeOutage.equals(other.m_nodeOutage)) {
            return false;
        }
        if (this.m_packages == null ? other.m_packages != null : !this.m_packages.equals(other.m_packages)) {
            return false;
        }
        if (this.m_pathOutageEnabled == null ? other.m_pathOutageEnabled != null : !this.m_pathOutageEnabled.equals(other.m_pathOutageEnabled)) {
            return false;
        }
        if (this.m_serviceUnresponsiveEnabled == null ? other.m_serviceUnresponsiveEnabled != null : !this.m_serviceUnresponsiveEnabled.equals(other.m_serviceUnresponsiveEnabled)) {
            return false;
        }
        if (this.m_threads == null ? other.m_threads != null : !this.m_threads.equals(other.m_threads)) {
            return false;
        }
        return !(this.m_xmlrpc == null ? other.m_xmlrpc != null : !this.m_xmlrpc.equals(other.m_xmlrpc));
    }

    public String toString() {
        return "PollerConfiguration[threads=" + this.m_threads + ",nextOutageId=" + this.m_nextOutageId + ",serviceUnresponsiveEnabled=" + this.m_serviceUnresponsiveEnabled + ",xmlrpc=" + this.m_xmlrpc + ",pathOutageEnabled=" + this.m_pathOutageEnabled + ",nodeOutage=" + this.m_nodeOutage + ",packages=" + this.m_packages + ",monitors=" + this.m_monitors + "]";
    }
}

