/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.Join;
import org.xml.sax.ContentHandler;

public class Table
implements Serializable {
    private String _visible = "true";
    private String _name;
    private String _key = "secondary";
    private List<Join> _joinList;
    private List<Column> _columnList;

    public Table() {
        this.setVisible("true");
        this.setKey("secondary");
        this._joinList = new ArrayList<Join>();
        this._columnList = new ArrayList<Column>();
    }

    public void addColumn(Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(vColumn);
    }

    public void addColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(index, vColumn);
    }

    public void addJoin(Join vJoin) throws IndexOutOfBoundsException {
        this._joinList.add(vJoin);
    }

    public void addJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        this._joinList.add(index, vJoin);
    }

    public Enumeration<Column> enumerateColumn() {
        return Collections.enumeration(this._columnList);
    }

    public Enumeration<Join> enumerateJoin() {
        return Collections.enumeration(this._joinList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Table) {
            Table temp = (Table)obj;
            if (this._visible != null) {
                if (temp._visible == null) {
                    return false;
                }
                if (!this._visible.equals(temp._visible)) {
                    return false;
                }
            } else if (temp._visible != null) {
                return false;
            }
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._key != null) {
                if (temp._key == null) {
                    return false;
                }
                if (!this._key.equals(temp._key)) {
                    return false;
                }
            } else if (temp._key != null) {
                return false;
            }
            if (this._joinList != null) {
                if (temp._joinList == null) {
                    return false;
                }
                if (!this._joinList.equals(temp._joinList)) {
                    return false;
                }
            } else if (temp._joinList != null) {
                return false;
            }
            if (this._columnList != null) {
                if (temp._columnList == null) {
                    return false;
                }
                if (!this._columnList.equals(temp._columnList)) {
                    return false;
                }
            } else if (temp._columnList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Column getColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnList.size()) {
            throw new IndexOutOfBoundsException("getColumn: Index value '" + index + "' not in range [0.." + (this._columnList.size() - 1) + "]");
        }
        return this._columnList.get(index);
    }

    public Column[] getColumn() {
        Column[] array = new Column[]{};
        return this._columnList.toArray(array);
    }

    public List<Column> getColumnCollection() {
        return this._columnList;
    }

    public int getColumnCount() {
        return this._columnList.size();
    }

    public Join getJoin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._joinList.size()) {
            throw new IndexOutOfBoundsException("getJoin: Index value '" + index + "' not in range [0.." + (this._joinList.size() - 1) + "]");
        }
        return this._joinList.get(index);
    }

    public Join[] getJoin() {
        Join[] array = new Join[]{};
        return this._joinList.toArray(array);
    }

    public List<Join> getJoinCollection() {
        return this._joinList;
    }

    public int getJoinCount() {
        return this._joinList.size();
    }

    public String getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getVisible() {
        return this._visible;
    }

    public int hashCode() {
        int result = 17;
        if (this._visible != null) {
            result = 37 * result + this._visible.hashCode();
        }
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._key != null) {
            result = 37 * result + this._key.hashCode();
        }
        if (this._joinList != null) {
            result = 37 * result + this._joinList.hashCode();
        }
        if (this._columnList != null) {
            result = 37 * result + this._columnList.hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Column> iterateColumn() {
        return this._columnList.iterator();
    }

    public Iterator<Join> iterateJoin() {
        return this._joinList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllColumn() {
        this._columnList.clear();
    }

    public void removeAllJoin() {
        this._joinList.clear();
    }

    public boolean removeColumn(Column vColumn) {
        boolean removed = this._columnList.remove(vColumn);
        return removed;
    }

    public Column removeColumnAt(int index) {
        Column obj = this._columnList.remove(index);
        return obj;
    }

    public boolean removeJoin(Join vJoin) {
        boolean removed = this._joinList.remove(vJoin);
        return removed;
    }

    public Join removeJoinAt(int index) {
        Join obj = this._joinList.remove(index);
        return obj;
    }

    public void setColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._columnList.size()) {
            throw new IndexOutOfBoundsException("setColumn: Index value '" + index + "' not in range [0.." + (this._columnList.size() - 1) + "]");
        }
        this._columnList.set(index, vColumn);
    }

    public void setColumn(Column[] vColumnArray) {
        this._columnList.clear();
        for (int i = 0; i < vColumnArray.length; ++i) {
            this._columnList.add(vColumnArray[i]);
        }
    }

    public void setColumn(List<Column> vColumnList) {
        this._columnList.clear();
        this._columnList.addAll(vColumnList);
    }

    public void setColumnCollection(List<Column> columnList) {
        this._columnList = columnList;
    }

    public void setJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._joinList.size()) {
            throw new IndexOutOfBoundsException("setJoin: Index value '" + index + "' not in range [0.." + (this._joinList.size() - 1) + "]");
        }
        this._joinList.set(index, vJoin);
    }

    public void setJoin(Join[] vJoinArray) {
        this._joinList.clear();
        for (int i = 0; i < vJoinArray.length; ++i) {
            this._joinList.add(vJoinArray[i]);
        }
    }

    public void setJoin(List<Join> vJoinList) {
        this._joinList.clear();
        this._joinList.addAll(vJoinList);
    }

    public void setJoinCollection(List<Join> joinList) {
        this._joinList = joinList;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setVisible(String visible) {
        this._visible = visible;
    }

    public static Table unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Table)Unmarshaller.unmarshal(Table.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

