/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.net.InetAddress;

public class AmiAgentConfig {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RETRIES = 1;
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_USERNAME = "opennms";
    public static final int DEFAULT_PORT = 5038;
    public static final int DEFAULT_TLS_PORT = 5039;
    public static final boolean DEFAULT_USE_TLS = false;
    private InetAddress m_address;
    private int m_timeout;
    private int m_retries;
    private String m_username;
    private String m_password;
    private int m_port;
    private boolean m_useTls;
    String user = "";
    String pass = "";
    String matchType = "all";

    public AmiAgentConfig() {
        this.setDefaults();
    }

    public AmiAgentConfig(InetAddress agentAddress) {
        this.m_address = agentAddress;
        this.setDefaults();
    }

    private void setDefaults() {
        this.m_timeout = 3000;
        this.m_retries = 1;
        this.m_port = 5038;
        this.m_useTls = false;
        this.m_username = DEFAULT_USERNAME;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AgentConfig[");
        buff.append("Address: " + this.m_address);
        buff.append(", Port: " + this.m_port);
        buff.append(", TLS: " + this.m_useTls);
        buff.append(", Username: " + String.valueOf(this.m_username));
        buff.append(", Password: " + String.valueOf(this.m_password));
        buff.append(", Timeout: " + this.m_timeout);
        buff.append(", Retries: " + this.m_retries);
        buff.append("]");
        return buff.toString();
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public boolean getUseTls() {
        return this.m_useTls;
    }

    public void setUseTls(boolean useTls) {
        this.m_useTls = useTls;
    }
}

