/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.vacuumd.Automation;

@XmlRootElement(name="automations")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Automations
implements Serializable {
    private static final long serialVersionUID = 7676358751414193033L;
    @XmlElement(name="automation")
    private List<Automation> _automationList = new ArrayList<Automation>(0);

    public Automations() {
    }

    public Automations(List<Automation> automations) {
        this._automationList = automations;
    }

    public void addAutomation(Automation vAutomation) throws IndexOutOfBoundsException {
        this._automationList.add(vAutomation);
    }

    public void addAutomation(int index, Automation vAutomation) throws IndexOutOfBoundsException {
        this._automationList.add(index, vAutomation);
    }

    public Enumeration<Automation> enumerateAutomation() {
        return Collections.enumeration(this._automationList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Automations) {
            Automations temp = (Automations)obj;
            if (this._automationList != null) {
                if (temp._automationList == null) {
                    return false;
                }
                if (!((Object)this._automationList).equals(temp._automationList)) {
                    return false;
                }
            } else if (temp._automationList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Automation getAutomation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._automationList.size()) {
            throw new IndexOutOfBoundsException("getAutomation: Index value '" + index + "' not in range [0.." + (this._automationList.size() - 1) + "]");
        }
        return this._automationList.get(index);
    }

    public Automation[] getAutomation() {
        Automation[] array = new Automation[]{};
        return this._automationList.toArray(array);
    }

    public List<Automation> getAutomationCollection() {
        return this._automationList;
    }

    public int getAutomationCount() {
        return this._automationList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._automationList != null) {
            result = 37 * result + ((Object)this._automationList).hashCode();
        }
        return result;
    }

    public Iterator<Automation> iterateAutomation() {
        return this._automationList.iterator();
    }

    public void removeAllAutomation() {
        this._automationList.clear();
    }

    public boolean removeAutomation(Automation vAutomation) {
        boolean removed = this._automationList.remove(vAutomation);
        return removed;
    }

    public Automation removeAutomationAt(int index) {
        Automation obj = this._automationList.remove(index);
        return obj;
    }

    public void setAutomation(int index, Automation vAutomation) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._automationList.size()) {
            throw new IndexOutOfBoundsException("setAutomation: Index value '" + index + "' not in range [0.." + (this._automationList.size() - 1) + "]");
        }
        this._automationList.set(index, vAutomation);
    }

    public void setAutomation(Automation[] vAutomationArray) {
        this._automationList.clear();
        for (int i = 0; i < vAutomationArray.length; ++i) {
            this._automationList.add(vAutomationArray[i]);
        }
    }

    public void setAutomation(List<Automation> vAutomationList) {
        this._automationList.clear();
        this._automationList.addAll(vAutomationList);
    }
}

