/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.service.Service;

@XmlRootElement(name="service-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceConfiguration
implements Serializable {
    private static final long serialVersionUID = 1477638002034420045L;
    @XmlElement(name="service")
    private List<Service> _serviceList = new ArrayList<Service>(0);

    public ServiceConfiguration() {
    }

    public ServiceConfiguration(List<Service> serviceList) {
        this.setService(serviceList);
    }

    public void addService(Service vService) throws IndexOutOfBoundsException {
        this._serviceList.add(vService);
    }

    public void addService(int index, Service vService) throws IndexOutOfBoundsException {
        this._serviceList.add(index, vService);
    }

    public Enumeration<Service> enumerateService() {
        return Collections.enumeration(this._serviceList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceConfiguration) {
            ServiceConfiguration temp = (ServiceConfiguration)obj;
            if (this._serviceList != null) {
                if (temp._serviceList == null) {
                    return false;
                }
                if (!((Object)this._serviceList).equals(temp._serviceList)) {
                    return false;
                }
            } else if (temp._serviceList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Service getService(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._serviceList.size()) {
            throw new IndexOutOfBoundsException("getService: Index value '" + index + "' not in range [0.." + (this._serviceList.size() - 1) + "]");
        }
        return this._serviceList.get(index);
    }

    public Service[] getService() {
        Service[] array = new Service[]{};
        return this._serviceList.toArray(array);
    }

    public List<Service> getServiceCollection() {
        return this._serviceList;
    }

    public int getServiceCount() {
        return this._serviceList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._serviceList != null) {
            result = 37 * result + ((Object)this._serviceList).hashCode();
        }
        return result;
    }

    public Iterator<Service> iterateService() {
        return this._serviceList.iterator();
    }

    public void removeAllService() {
        this._serviceList.clear();
    }

    public boolean removeService(Service vService) {
        boolean removed = this._serviceList.remove(vService);
        return removed;
    }

    public Service removeServiceAt(int index) {
        Service obj = this._serviceList.remove(index);
        return obj;
    }

    public void setService(int index, Service vService) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._serviceList.size()) {
            throw new IndexOutOfBoundsException("setService: Index value '" + index + "' not in range [0.." + (this._serviceList.size() - 1) + "]");
        }
        this._serviceList.set(index, vService);
    }

    public void setService(Service[] vServiceArray) {
        this._serviceList.clear();
        for (int i = 0; i < vServiceArray.length; ++i) {
            this._serviceList.add(vServiceArray[i]);
        }
    }

    public void setService(List<Service> vServiceList) {
        this._serviceList.clear();
        this._serviceList.addAll(vServiceList);
    }
}

