/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.config.service.types.InvokeAtTypeAdapter;

@XmlRootElement(name="invoke")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Invoke
implements Serializable {
    private static final long serialVersionUID = 1295387509696778585L;
    @XmlAttribute(name="method")
    private String _method;
    @XmlAttribute(name="pass")
    private Integer _pass = 0;
    @XmlAttribute(name="at")
    @XmlJavaTypeAdapter(value=InvokeAtTypeAdapter.class)
    private InvokeAtType _at;
    @XmlElement(name="argument")
    private List<Argument> _argumentList = new ArrayList<Argument>(0);

    public Invoke() {
    }

    public Invoke(InvokeAtType type, Integer pass, String method, List<Argument> arguments) {
        this.setAt(type);
        this.setPass(pass);
        this.setMethod(method);
        this.setArgument(arguments);
    }

    public void addArgument(Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(vArgument);
    }

    public void addArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(index, vArgument);
    }

    public void deletePass() {
        this._pass = null;
    }

    public Enumeration<Argument> enumerateArgument() {
        return Collections.enumeration(this._argumentList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Invoke) {
            Invoke temp = (Invoke)obj;
            if (this._method != null) {
                if (temp._method == null) {
                    return false;
                }
                if (!this._method.equals(temp._method)) {
                    return false;
                }
            } else if (temp._method != null) {
                return false;
            }
            if (this._pass != temp._pass) {
                return false;
            }
            if (this._at != null) {
                if (temp._at == null) {
                    return false;
                }
                if (!this._at.equals(temp._at)) {
                    return false;
                }
            } else if (temp._at != null) {
                return false;
            }
            if (this._argumentList != null) {
                if (temp._argumentList == null) {
                    return false;
                }
                if (!((Object)this._argumentList).equals(temp._argumentList)) {
                    return false;
                }
            } else if (temp._argumentList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Argument getArgument(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._argumentList.size()) {
            throw new IndexOutOfBoundsException("getArgument: Index value '" + index + "' not in range [0.." + (this._argumentList.size() - 1) + "]");
        }
        return this._argumentList.get(index);
    }

    public Argument[] getArgument() {
        Argument[] array = new Argument[]{};
        return this._argumentList.toArray(array);
    }

    public List<Argument> getArgumentCollection() {
        return this._argumentList;
    }

    public int getArgumentCount() {
        return this._argumentList.size();
    }

    public InvokeAtType getAt() {
        return this._at;
    }

    public String getMethod() {
        return this._method;
    }

    public int getPass() {
        return this._pass;
    }

    public boolean hasPass() {
        return this._pass != null;
    }

    public int hashCode() {
        int result = 17;
        if (this._method != null) {
            result = 37 * result + this._method.hashCode();
        }
        result = 37 * result + this._pass;
        if (this._at != null) {
            result = 37 * result + this._at.hashCode();
        }
        if (this._argumentList != null) {
            result = 37 * result + ((Object)this._argumentList).hashCode();
        }
        return result;
    }

    public Iterator<Argument> iterateArgument() {
        return this._argumentList.iterator();
    }

    public void removeAllArgument() {
        this._argumentList.clear();
    }

    public boolean removeArgument(Argument vArgument) {
        boolean removed = this._argumentList.remove(vArgument);
        return removed;
    }

    public Argument removeArgumentAt(int index) {
        Argument obj = this._argumentList.remove(index);
        return obj;
    }

    public void setArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._argumentList.size()) {
            throw new IndexOutOfBoundsException("setArgument: Index value '" + index + "' not in range [0.." + (this._argumentList.size() - 1) + "]");
        }
        this._argumentList.set(index, vArgument);
    }

    public void setArgument(Argument[] vArgumentArray) {
        this._argumentList.clear();
        for (int i = 0; i < vArgumentArray.length; ++i) {
            this._argumentList.add(vArgumentArray[i]);
        }
    }

    public void setArgument(List<Argument> vArgumentList) {
        this._argumentList.clear();
        this._argumentList.addAll(vArgumentList);
    }

    public void setAt(InvokeAtType at) {
        this._at = at;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setPass(int pass) {
        this._pass = pass;
    }
}

