/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller.outages;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="outages", namespace="http://xmlns.opennms.org/xsd/config/poller/outages")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="poll-outages.xsd")
public class Outages
implements Serializable {
    private static final Outage[] EMPTY_OUTAGE_LIST = new Outage[0];
    private static final long serialVersionUID = 2135204624761990598L;
    @XmlElement(name="outage")
    private List<Outage> m_outages = new ArrayList<Outage>();

    public void addOutage(Outage outage) throws IndexOutOfBoundsException {
        this.m_outages.add(outage);
    }

    public void addOutage(int index, Outage outage) throws IndexOutOfBoundsException {
        this.m_outages.add(index, outage);
    }

    public Enumeration<Outage> enumerateOutage() {
        return Collections.enumeration(this.m_outages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Outages) {
            Outages temp = (Outages)obj;
            if (this.m_outages != null) {
                if (temp.m_outages == null) {
                    return false;
                }
                if (!((Object)this.m_outages).equals(temp.m_outages)) {
                    return false;
                }
            } else if (temp.m_outages != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Outage getOutage(int index) throws IndexOutOfBoundsException {
        return this.m_outages.get(index);
    }

    public Outage[] getOutage() {
        return this.m_outages.toArray(EMPTY_OUTAGE_LIST);
    }

    public List<Outage> getOutageCollection() {
        return new ArrayList<Outage>(this.m_outages);
    }

    public int getOutageCount() {
        return this.m_outages.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_outages != null) {
            result = 37 * result + ((Object)this.m_outages).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Outage> iterateOutage() {
        return this.m_outages.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllOutage() {
        this.m_outages.clear();
    }

    public boolean removeOutage(Outage outage) {
        return this.m_outages.remove(outage);
    }

    public Outage removeOutageAt(int index) {
        return this.m_outages.remove(index);
    }

    public void setOutage(int index, Outage outage) throws IndexOutOfBoundsException {
        this.m_outages.set(index, outage);
    }

    public void setOutage(Outage[] outages) {
        this.m_outages.clear();
        for (Outage outage : outages) {
            this.m_outages.add(outage);
        }
    }

    public void setOutage(List<Outage> outages) {
        if (outages != this.m_outages) {
            this.m_outages.clear();
            this.m_outages.addAll(outages);
        }
    }

    public void setOutageCollection(List<Outage> outages) {
        this.m_outages = new ArrayList<Outage>(outages);
    }

    @Deprecated
    public static Outages unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Outages)Unmarshaller.unmarshal(Outages.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    public String toString() {
        return "Outages[outages=" + this.m_outages + "]";
    }
}

