/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.monitoringLocations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;

@XmlRootElement(name="monitoring-locations-configuration")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="monitoring-locations.xsd")
public class MonitoringLocationsConfiguration
implements Serializable {
    private static final long serialVersionUID = 4774677097952128710L;
    @XmlElementWrapper(name="locations")
    @XmlElement(name="location-def")
    private List<LocationDef> m_locations;

    public List<LocationDef> getLocations() {
        if (this.m_locations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_locations);
    }

    public void setLocations(List<LocationDef> locations) {
        this.m_locations = locations == null || locations.size() == 0 ? null : new ArrayList<LocationDef>(locations);
    }

    public LocationDef getLocation(String location) {
        for (LocationDef def : this.m_locations) {
            if (!def.getLocationName().equals(location)) continue;
            return def;
        }
        return null;
    }

    public void addLocation(LocationDef location) {
        if (this.m_locations == null) {
            this.m_locations = new ArrayList<LocationDef>();
        }
        this.m_locations.add(location);
    }

    public void addLocation(String locationName, String monitoringArea, String pollingPackageName, String collectionPackageName, String geolocation, String coordinates, Long priority, String ... tags) {
        this.addLocation(new LocationDef(locationName, monitoringArea, pollingPackageName, collectionPackageName, geolocation, coordinates, priority, tags));
    }

    public int hashCode() {
        int prime = 383;
        int result = 1;
        result = 383 * result + (this.m_locations == null || this.m_locations.size() == 0 ? 0 : ((Object)this.m_locations).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringLocationsConfiguration)) {
            return false;
        }
        MonitoringLocationsConfiguration other = (MonitoringLocationsConfiguration)obj;
        if (this.m_locations == null || this.m_locations.size() == 0) {
            if (other.m_locations != null && other.m_locations.size() > 0) {
                return false;
            }
        } else {
            if (other.m_locations == null || other.m_locations.size() == 0) {
                return false;
            }
            if (!((Object)this.m_locations).equals(other.m_locations)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "MonitoringLocationsConfiguration [locations=" + this.m_locations + "]";
    }
}

