/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.network.IPAddress;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.netmgt.config.collectd.ExcludeRange;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.IncludeRange;
import org.opennms.netmgt.config.collectd.Service;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Package
implements Serializable {
    private static final long serialVersionUID = 1689693370360064016L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="filter")
    private Filter m_filter;
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="include-range")
    private List<IncludeRange> m_includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    private List<ExcludeRange> m_excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    private List<String> m_includeUrls = new ArrayList<String>();
    @XmlElement(name="storeByIfAlias")
    private String m_storeByIfAlias;
    @XmlElement(name="storeByNodeID")
    private String m_storeByNodeID;
    @XmlElement(name="ifAliasDomain")
    private String m_ifAliasDomain;
    @XmlElement(name="storFlagOverride")
    private String m_storFlagOverride;
    @XmlElement(name="ifAliasComment")
    private String m_ifAliasComment;
    @XmlElement(name="service")
    private List<Service> m_services = new ArrayList<Service>();
    @XmlElement(name="outage-calendar")
    private List<String> m_outageCalendar = new ArrayList<String>();

    public Package() {
    }

    public Package(Package pkg) {
        this.setExcludeRanges(pkg.getExcludeRanges());
        this.setFilter(pkg.getFilter());
        this.setIfAliasComment(pkg.getIfAliasComment());
        this.setIfAliasDomain(pkg.getIfAliasDomain());
        this.setIncludeRanges(pkg.getIncludeRanges());
        this.setIncludeUrlCollection(pkg.getIncludeUrls());
        this.setName(pkg.getName());
        this.setOutageCalendars(pkg.getOutageCalendars());
        this.setServices(pkg.getServices());
        this.setSpecifics(pkg.getSpecifics());
        this.setStoreByIfAlias(pkg.getStoreByIfAlias());
        this.setStoreByNodeID(pkg.getStoreByNodeID());
        this.setStorFlagOverride(pkg.getStorFlagOverride());
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public List<String> getSpecifics() {
        if (this.m_specifics == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_specifics);
    }

    public void setSpecifics(List<String> specifics) {
        this.m_specifics = new ArrayList<String>(specifics);
    }

    public void addSpecific(String specific) throws IndexOutOfBoundsException {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(String specific) {
        return this.m_specifics.remove(specific);
    }

    public boolean hasSpecific(byte[] addr) {
        IPAddress ipAddr = new IPAddress(addr);
        for (String espec : this.getSpecifics()) {
            if (!ipAddr.equals((Object)new IPAddress(espec))) continue;
            return true;
        }
        return false;
    }

    public List<IncludeRange> getIncludeRanges() {
        if (this.m_includeRanges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeRanges);
    }

    public void setIncludeRanges(List<IncludeRange> ranges) {
        this.m_includeRanges = new ArrayList<IncludeRange>(ranges);
    }

    public void addIncludeRange(IncludeRange range) throws IndexOutOfBoundsException {
        this.m_includeRanges.add(range);
    }

    public boolean removeIncludeRange(IncludeRange range) {
        return this.m_includeRanges.remove(range);
    }

    public boolean hasIncludeRange(String addr) {
        if (this.getIncludeRanges().size() == 0 && this.getSpecifics().size() == 0) {
            return true;
        }
        IPAddress ipAddr = new IPAddress(addr);
        for (IncludeRange rng : this.getIncludeRanges()) {
            IPAddress begin = rng.getBeginAsAddress();
            IPAddress end = rng.getEndAsAddress();
            if (!ipAddr.isGreaterThanOrEqualTo(begin) || !ipAddr.isLessThanOrEqualTo(end)) continue;
            return true;
        }
        return false;
    }

    public List<ExcludeRange> getExcludeRanges() {
        if (this.m_excludeRanges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_excludeRanges);
    }

    public void setExcludeRanges(List<ExcludeRange> ranges) {
        this.m_excludeRanges = new ArrayList<ExcludeRange>(ranges);
    }

    public void addExcludeRange(ExcludeRange range) throws IndexOutOfBoundsException {
        this.m_excludeRanges.add(range);
    }

    public boolean removeExcludeRange(ExcludeRange range) {
        return this.m_excludeRanges.remove(range);
    }

    public boolean hasExcludeRange(String addr) {
        IPAddress ipAddr = new IPAddress(addr);
        for (ExcludeRange rng : this.getExcludeRanges()) {
            IPAddress begin = rng.getBeginAsAddress();
            IPAddress end = rng.getEndAsAddress();
            if (!ipAddr.isGreaterThanOrEqualTo(begin) || !ipAddr.isLessThanOrEqualTo(end)) continue;
            return true;
        }
        return false;
    }

    public List<String> getIncludeUrls() {
        if (this.m_includeUrls == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeUrls);
    }

    public void setIncludeUrlCollection(List<String> urls) {
        this.m_includeUrls = new ArrayList<String>(urls);
    }

    public void addIncludeUrl(String url) throws IndexOutOfBoundsException {
        this.m_includeUrls.add(url);
    }

    public boolean removeIncludeUrl(String url) {
        return this.m_includeUrls.remove(url);
    }

    public boolean hasSpecificUrl(String iface, boolean hasSpecific) {
        if (hasSpecific) {
            return true;
        }
        IPAddress addr = new IPAddress(iface);
        for (String includeURL : this.getIncludeUrls()) {
            List ips = IpListFromUrl.fetch((String)includeURL);
            for (String includeAddr : ips) {
                if (!new IPAddress(includeAddr).equals((Object)addr)) continue;
                return true;
            }
        }
        return false;
    }

    public String getStoreByIfAlias() {
        return this.m_storeByIfAlias;
    }

    public void setStoreByIfAlias(String storeByIfAlias) {
        this.m_storeByIfAlias = storeByIfAlias;
    }

    public String getStoreByNodeID() {
        return this.m_storeByNodeID;
    }

    public void setStoreByNodeID(String storeByNodeID) {
        this.m_storeByNodeID = storeByNodeID;
    }

    public String getStorFlagOverride() {
        return this.m_storFlagOverride;
    }

    public void setStorFlagOverride(String storFlagOverride) {
        this.m_storFlagOverride = storFlagOverride;
    }

    public String getIfAliasDomain() {
        return this.m_ifAliasDomain;
    }

    public void setIfAliasDomain(String ifAliasDomain) {
        this.m_ifAliasDomain = ifAliasDomain;
    }

    public String getIfAliasComment() {
        return this.m_ifAliasComment;
    }

    public void setIfAliasComment(String ifAliasComment) {
        this.m_ifAliasComment = ifAliasComment;
    }

    public List<Service> getServices() {
        if (this.m_services == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_services);
    }

    public void setServices(List<Service> services) {
        this.m_services = new ArrayList<Service>(services);
    }

    public void addService(Service service) throws IndexOutOfBoundsException {
        this.m_services.add(service);
    }

    public boolean removeService(Service service) {
        return this.m_services.remove(service);
    }

    public Service getService(String svcName) {
        List<Service> pkgSvcs = this.getServices();
        for (Service svc : pkgSvcs) {
            if (!svc.getName().equalsIgnoreCase(svcName)) continue;
            return svc;
        }
        throw new IllegalArgumentException("Service name not part of package!");
    }

    public boolean serviceInPackageAndEnabled(String svcName) {
        for (Service service : this.getServices()) {
            if (!service.getName().equalsIgnoreCase(svcName) || !"on".equals(service.getStatus())) continue;
            return true;
        }
        return false;
    }

    public List<String> getOutageCalendars() {
        if (this.m_outageCalendar == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_outageCalendar);
    }

    public void setOutageCalendars(List<String> calendars) {
        this.m_outageCalendar = new ArrayList<String>(calendars);
    }

    public void addOutageCalendar(String calendar) throws IndexOutOfBoundsException {
        this.m_outageCalendar.add(calendar);
    }

    public boolean removeOutageCalendar(String calendar) {
        return this.m_outageCalendar.remove(calendar);
    }

    public int hashCode() {
        int prime = 727;
        int result = 1;
        result = 727 * result + (this.m_excludeRanges == null ? 0 : ((Object)this.m_excludeRanges).hashCode());
        result = 727 * result + (this.m_filter == null ? 0 : this.m_filter.hashCode());
        result = 727 * result + (this.m_ifAliasComment == null ? 0 : this.m_ifAliasComment.hashCode());
        result = 727 * result + (this.m_ifAliasDomain == null ? 0 : this.m_ifAliasDomain.hashCode());
        result = 727 * result + (this.m_includeRanges == null ? 0 : ((Object)this.m_includeRanges).hashCode());
        result = 727 * result + (this.m_includeUrls == null ? 0 : ((Object)this.m_includeUrls).hashCode());
        result = 727 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 727 * result + (this.m_outageCalendar == null ? 0 : ((Object)this.m_outageCalendar).hashCode());
        result = 727 * result + (this.m_services == null ? 0 : ((Object)this.m_services).hashCode());
        result = 727 * result + (this.m_specifics == null ? 0 : ((Object)this.m_specifics).hashCode());
        result = 727 * result + (this.m_storFlagOverride == null ? 0 : this.m_storFlagOverride.hashCode());
        result = 727 * result + (this.m_storeByIfAlias == null ? 0 : this.m_storeByIfAlias.hashCode());
        result = 727 * result + (this.m_storeByNodeID == null ? 0 : this.m_storeByNodeID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Package)) {
            return false;
        }
        Package other = (Package)obj;
        if (this.m_excludeRanges == null ? other.m_excludeRanges != null : !((Object)this.m_excludeRanges).equals(other.m_excludeRanges)) {
            return false;
        }
        if (this.m_filter == null ? other.m_filter != null : !this.m_filter.equals(other.m_filter)) {
            return false;
        }
        if (this.m_ifAliasComment == null ? other.m_ifAliasComment != null : !this.m_ifAliasComment.equals(other.m_ifAliasComment)) {
            return false;
        }
        if (this.m_ifAliasDomain == null ? other.m_ifAliasDomain != null : !this.m_ifAliasDomain.equals(other.m_ifAliasDomain)) {
            return false;
        }
        if (this.m_includeRanges == null ? other.m_includeRanges != null : !((Object)this.m_includeRanges).equals(other.m_includeRanges)) {
            return false;
        }
        if (this.m_includeUrls == null ? other.m_includeUrls != null : !((Object)this.m_includeUrls).equals(other.m_includeUrls)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_outageCalendar == null ? other.m_outageCalendar != null : !((Object)this.m_outageCalendar).equals(other.m_outageCalendar)) {
            return false;
        }
        if (this.m_services == null ? other.m_services != null : !((Object)this.m_services).equals(other.m_services)) {
            return false;
        }
        if (this.m_specifics == null ? other.m_specifics != null : !((Object)this.m_specifics).equals(other.m_specifics)) {
            return false;
        }
        if (this.m_storFlagOverride == null ? other.m_storFlagOverride != null : !this.m_storFlagOverride.equals(other.m_storFlagOverride)) {
            return false;
        }
        if (this.m_storeByIfAlias == null ? other.m_storeByIfAlias != null : !this.m_storeByIfAlias.equals(other.m_storeByIfAlias)) {
            return false;
        }
        return !(this.m_storeByNodeID == null ? other.m_storeByNodeID != null : !this.m_storeByNodeID.equals(other.m_storeByNodeID));
    }

    public String toString() {
        return "Package [name=" + this.m_name + ", filter=" + this.m_filter + ", specifics=" + this.m_specifics + ", includeRanges=" + this.m_includeRanges + ", excludeRanges=" + this.m_excludeRanges + ", includeUrls=" + this.m_includeUrls + ", storeByIfAlias=" + this.m_storeByIfAlias + ", storeByNodeID=" + this.m_storeByNodeID + ", ifAliasDomain=" + this.m_ifAliasDomain + ", storFlagOverride=" + this.m_storFlagOverride + ", ifAliasComment=" + this.m_ifAliasComment + ", services=" + this.m_services + ", outageCalendar=" + this.m_outageCalendar + "]";
    }
}

