/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.collectd.Parameter;

@XmlRootElement(name="collector")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Collector
implements Serializable {
    private static final long serialVersionUID = -2414670000700025730L;
    @XmlAttribute(name="service")
    private String m_service;
    @XmlAttribute(name="class-name")
    private String m_className;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public Collector() {
    }

    public Collector(String service, String className) {
        this();
        this.m_service = service;
        this.m_className = className;
    }

    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        this.m_service = service;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public List<Parameter> getParameters() {
        if (this.m_parameters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.m_parameters = new ArrayList<Parameter>(parameters);
    }

    public void addParameter(Parameter parameter) throws IndexOutOfBoundsException {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        int prime = 179;
        int result = 1;
        result = 179 * result + (this.m_className == null ? 0 : this.m_className.hashCode());
        result = 179 * result + (this.m_parameters == null ? 0 : ((Object)this.m_parameters).hashCode());
        result = 179 * result + (this.m_service == null ? 0 : this.m_service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collector)) {
            return false;
        }
        Collector other = (Collector)obj;
        if (this.m_className == null ? other.m_className != null : !this.m_className.equals(other.m_className)) {
            return false;
        }
        if (this.m_parameters == null ? other.m_parameters != null : !((Object)this.m_parameters).equals(other.m_parameters)) {
            return false;
        }
        return !(this.m_service == null ? other.m_service != null : !this.m_service.equals(other.m_service));
    }

    public String toString() {
        return "Collector [service=" + this.m_service + ", className=" + this.m_className + ", parameters=" + this.m_parameters + "]";
    }
}

