/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ackd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.ackd.ReaderSchedule;

@XmlRootElement(name="reader")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Reader
implements Serializable {
    private static final long serialVersionUID = -7392047026243024472L;
    public static final boolean DEFAULT_ENABLED_FLAG = true;
    @XmlAttribute(name="reader-name")
    private String _readerName;
    @XmlAttribute(name="enabled")
    private Boolean _enabled;
    @XmlElement(name="reader-schedule")
    private ReaderSchedule _readerSchedule;
    @XmlElement(name="parameter")
    private List<Parameter> _parameterList = new ArrayList<Parameter>(0);

    public Reader() {
    }

    public Reader(String name, boolean enabled, ReaderSchedule schedule, List<Parameter> parameters) {
        this.setReaderName(name);
        this.setEnabled(enabled);
        this.setReaderSchedule(schedule);
        this.setParameter(parameters);
    }

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this._parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this._parameterList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reader other = (Reader)obj;
        if (this._enabled == null ? other._enabled != null : !this._enabled.equals(other._enabled)) {
            return false;
        }
        if (this._parameterList == null ? other._parameterList != null : !((Object)this._parameterList).equals(other._parameterList)) {
            return false;
        }
        if (this._readerName == null ? other._readerName != null : !this._readerName.equals(other._readerName)) {
            return false;
        }
        return !(this._readerSchedule == null ? other._readerSchedule != null : !this._readerSchedule.equals(other._readerSchedule));
    }

    public boolean getEnabled() {
        return this._enabled == null ? true : this._enabled;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        return this._parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this._parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this._parameterList;
    }

    public int getParameterCount() {
        return this._parameterList.size();
    }

    public String getReaderName() {
        return this._readerName;
    }

    public ReaderSchedule getReaderSchedule() {
        return this._readerSchedule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._enabled == null ? 0 : this._enabled.hashCode());
        result = 31 * result + (this._parameterList == null ? 0 : ((Object)this._parameterList).hashCode());
        result = 31 * result + (this._readerName == null ? 0 : this._readerName.hashCode());
        result = 31 * result + (this._readerSchedule == null ? 0 : this._readerSchedule.hashCode());
        return result;
    }

    public boolean isEnabled() {
        return this._enabled == null ? true : this._enabled;
    }

    public Iterator<Parameter> iterateParameter() {
        return this._parameterList.iterator();
    }

    public void removeAllParameter() {
        this._parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        return this._parameterList.remove(vParameter);
    }

    public Parameter removeParameterAt(int index) {
        return this._parameterList.remove(index);
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this._parameterList.size() - 1) + "]");
        }
        this._parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this._parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this._parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this._parameterList.clear();
        this._parameterList.addAll(vParameterList);
    }

    public void setReaderName(String readerName) {
        this._readerName = readerName;
    }

    public void setReaderSchedule(ReaderSchedule readerSchedule) {
        this._readerSchedule = readerSchedule;
    }
}

