/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd.jmx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.collectd.jmx.Rrd;

@XmlRootElement(name="jmx-collection")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JmxCollection
implements Serializable {
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlTransient
    @Deprecated
    private int m_maxVarsPerPdu = 0;
    @XmlElement(name="rrd", required=true)
    private Rrd m_rrd;
    @XmlElement(name="mbean")
    @XmlElementWrapper(name="mbeans")
    private List<Mbean> m_mbeans = new ArrayList<Mbean>();
    @XmlElement(name="import-mbeans", required=false)
    private List<String> m_importMbeansList = new ArrayList<String>();

    @XmlTransient
    public List<String> getImportGroupsList() {
        return this.m_importMbeansList;
    }

    public void setImportGroupsList(List<String> importMbeansList) {
        this.m_importMbeansList = importMbeansList;
    }

    public boolean hasImportMbeans() {
        return this.m_importMbeansList != null && !this.m_importMbeansList.isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmxCollection) {
            JmxCollection temp = (JmxCollection)obj;
            boolean equals = Objects.equals(this.m_name, temp.m_name) && Objects.equals(this.m_maxVarsPerPdu, temp.m_maxVarsPerPdu) && Objects.equals(this.m_rrd, temp.m_rrd) && Objects.equals(this.m_mbeans, temp.m_mbeans);
            return equals;
        }
        return false;
    }

    public int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public List<Mbean> getMbeans() {
        return this.m_mbeans;
    }

    public String getName() {
        return this.m_name;
    }

    public Rrd getRrd() {
        return this.m_rrd;
    }

    public boolean hasMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu != 0;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_maxVarsPerPdu, this.m_rrd, this.m_mbeans);
    }

    public int getMbeanCount() {
        return this.m_mbeans.size();
    }

    public void addMbean(Mbean mbean) {
        if (mbean != null) {
            this.m_mbeans.add(mbean);
        }
    }

    @Deprecated
    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public void setMbeans(List<Mbean> mbeans) {
        this.m_mbeans = mbeans;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRrd(Rrd rrd) {
        this.m_rrd = rrd;
    }

    public void addMbeans(List<Mbean> mbeanList) {
        this.m_mbeans.addAll(mbeanList);
    }
}

