/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.Rrd;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.Systems;
import org.opennms.netmgt.config.internal.collection.DatacollectionConfigVisitor;

@XmlRootElement(name="snmp-collection", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class SnmpCollection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6632949516175500912L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="maxVarsPerPdu")
    private Integer m_maxVarsPerPdu;
    @XmlAttribute(name="snmpStorageFlag", required=true)
    private String m_snmpStorageFlag;
    @XmlElement(name="rrd", required=true)
    private Rrd m_rrd;
    @XmlElement(name="include-collection")
    private List<IncludeCollection> m_includeCollections = new ArrayList<IncludeCollection>();
    @XmlElement(name="resourceType")
    private List<ResourceType> m_resourceTypes = new ArrayList<ResourceType>();
    @XmlElement(name="groups")
    private Groups m_groups;
    @XmlElement(name="systems")
    private Systems m_systems;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    public Integer getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public void setMaxVarsPerPdu(Integer maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public String getSnmpStorageFlag() {
        return this.m_snmpStorageFlag;
    }

    public void setSnmpStorageFlag(String snmpStorageFlag) {
        this.m_snmpStorageFlag = snmpStorageFlag.intern();
    }

    public Rrd getRrd() {
        return this.m_rrd;
    }

    public void setRrd(Rrd rrd) {
        this.m_rrd = rrd;
    }

    public List<IncludeCollection> getIncludeCollections() {
        if (this.m_includeCollections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeCollections);
    }

    public void setIncludeCollections(List<IncludeCollection> includeCollections) {
        this.m_includeCollections = new ArrayList<IncludeCollection>(includeCollections);
    }

    public void addIncludeCollection(IncludeCollection includeCollection) throws IndexOutOfBoundsException {
        this.m_includeCollections.add(includeCollection);
    }

    public boolean removeIncludeCollection(IncludeCollection includeCollection) {
        return this.m_includeCollections.remove(includeCollection);
    }

    public List<ResourceType> getResourceTypes() {
        if (this.m_resourceTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_resourceTypes);
    }

    public void setResourceTypes(List<ResourceType> resourceTypes) {
        this.m_resourceTypes = new ArrayList<ResourceType>(resourceTypes);
    }

    public void addResourceType(ResourceType resourceType) throws IndexOutOfBoundsException {
        this.m_resourceTypes.add(resourceType);
    }

    public boolean removeResourceType(ResourceType resourceType) {
        return this.m_resourceTypes.remove(resourceType);
    }

    public Groups getGroups() {
        return this.m_groups;
    }

    public void setGroups(Groups groups) {
        this.m_groups = groups;
    }

    public Systems getSystems() {
        return this.m_systems;
    }

    public void setSystems(Systems systems) {
        this.m_systems = systems;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_groups == null ? 0 : this.m_groups.hashCode());
        result = 31 * result + (this.m_includeCollections == null ? 0 : this.m_includeCollections.hashCode());
        result = 31 * result + (this.m_maxVarsPerPdu == null ? 0 : this.m_maxVarsPerPdu.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_resourceTypes == null ? 0 : this.m_resourceTypes.hashCode());
        result = 31 * result + (this.m_rrd == null ? 0 : this.m_rrd.hashCode());
        result = 31 * result + (this.m_snmpStorageFlag == null ? 0 : this.m_snmpStorageFlag.hashCode());
        result = 31 * result + (this.m_systems == null ? 0 : this.m_systems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnmpCollection)) {
            return false;
        }
        SnmpCollection other = (SnmpCollection)obj;
        if (this.m_groups == null ? other.m_groups != null : !this.m_groups.equals(other.m_groups)) {
            return false;
        }
        if (this.m_includeCollections == null ? other.m_includeCollections != null : !this.m_includeCollections.equals(other.m_includeCollections)) {
            return false;
        }
        if (this.m_maxVarsPerPdu == null ? other.m_maxVarsPerPdu != null : !this.m_maxVarsPerPdu.equals(other.m_maxVarsPerPdu)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_resourceTypes == null ? other.m_resourceTypes != null : !this.m_resourceTypes.equals(other.m_resourceTypes)) {
            return false;
        }
        if (this.m_rrd == null ? other.m_rrd != null : !this.m_rrd.equals(other.m_rrd)) {
            return false;
        }
        if (this.m_snmpStorageFlag == null ? other.m_snmpStorageFlag != null : !this.m_snmpStorageFlag.equals(other.m_snmpStorageFlag)) {
            return false;
        }
        return !(this.m_systems == null ? other.m_systems != null : !this.m_systems.equals(other.m_systems));
    }

    public String toString() {
        return "SnmpCollection [name=" + this.m_name + ", maxVarsPerPdu=" + this.m_maxVarsPerPdu + ", snmpStorageFlag=" + this.m_snmpStorageFlag + ", rrd=" + this.m_rrd + ", includeCollections=" + this.m_includeCollections + ", resourceTypes=" + this.m_resourceTypes + ", groups=" + this.m_groups + ", systems=" + this.m_systems + "]";
    }

    public void visit(DatacollectionConfigVisitor visitor) {
        visitor.visitSnmpCollection(this);
        if (this.m_includeCollections != null) {
            for (IncludeCollection collection : this.m_includeCollections) {
                collection.visit(visitor);
            }
        }
        if (this.m_groups != null && this.m_groups.getGroups() != null) {
            for (Group group : this.m_groups.getGroups()) {
                group.visit(visitor);
            }
        }
        if (this.m_systems != null && this.m_systems.getSystemDefs() != null) {
            for (SystemDef def : this.m_systems.getSystemDefs()) {
                def.visit(visitor);
            }
        }
        if (this.m_resourceTypes != null) {
            for (ResourceType type : this.m_resourceTypes) {
                type.visit(visitor);
            }
        }
        visitor.visitSnmpCollectionComplete();
    }

    public SnmpCollection clone() {
        SnmpCollection newCollection = new SnmpCollection();
        newCollection.setGroups(this.getGroups());
        newCollection.setIncludeCollections(this.getIncludeCollections());
        newCollection.setMaxVarsPerPdu(this.getMaxVarsPerPdu());
        newCollection.setName(this.getName());
        newCollection.setResourceTypes(this.getResourceTypes());
        newCollection.setRrd(this.getRrd());
        newCollection.setSnmpStorageFlag(this.getSnmpStorageFlag());
        newCollection.setSystems(this.getSystems());
        return newCollection;
    }
}

