/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.trapd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.config.trapd.Snmpv3User;

@XmlRootElement(name="trapd-configuration")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TrapdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final boolean DEFAULT_USE_ADDESS_FROM_VARBIND = false;
    @XmlAttribute(name="snmp-trap-address")
    private String _snmpTrapAddress = "*";
    @XmlAttribute(name="snmp-trap-port", required=true)
    private int _snmpTrapPort;
    @XmlTransient
    private boolean _has_snmpTrapPort;
    @XmlAttribute(name="new-suspect-on-trap", required=true)
    private boolean _newSuspectOnTrap;
    @XmlAttribute(name="include-raw-message", required=false)
    private boolean _includeRawMessage;
    @XmlAttribute(name="threads", required=false)
    private int _threads = 0;
    @XmlAttribute(name="queue-size", required=false)
    private int _queueSize = 10000;
    @XmlAttribute(name="batch-size", required=false)
    private int _batchSize = 1000;
    @XmlAttribute(name="batch-interval", required=false)
    private int _batchInterval = 500;
    @XmlTransient
    private boolean _has_newSuspectOnTrap;
    @XmlElement(name="snmpv3-user")
    private List<Snmpv3User> _snmpv3UserList;
    @XmlAttribute(name="use-address-from-varbind", required=false)
    private Boolean _useAddessFromVarbind;

    public TrapdConfiguration() {
        this.setSnmpTrapAddress("*");
        this._snmpv3UserList = new ArrayList<Snmpv3User>();
    }

    public TrapdConfiguration(int _snmpTrapPort, String snmpTrapAddress) {
        this.setSnmpTrapAddress(snmpTrapAddress);
        this._snmpTrapPort = _snmpTrapPort;
        this._snmpv3UserList = new ArrayList<Snmpv3User>();
    }

    public void addSnmpv3User(Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        this._snmpv3UserList.add(vSnmpv3User);
    }

    public void addSnmpv3User(int index, Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        this._snmpv3UserList.add(index, vSnmpv3User);
    }

    public void deleteNewSuspectOnTrap() {
        this._has_newSuspectOnTrap = false;
    }

    public void deleteSnmpTrapPort() {
        this._has_snmpTrapPort = false;
    }

    public Enumeration<Snmpv3User> enumerateSnmpv3User() {
        return Collections.enumeration(this._snmpv3UserList);
    }

    public int hashCode() {
        return Objects.hash(this._snmpTrapAddress, this._snmpTrapPort, this._has_snmpTrapPort, this._newSuspectOnTrap, this._snmpv3UserList, this._includeRawMessage, this._threads, this._queueSize, this._batchSize, this._batchInterval, this._useAddessFromVarbind);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TrapdConfiguration) {
            TrapdConfiguration other = (TrapdConfiguration)obj;
            boolean equals = Objects.equals(this._snmpTrapAddress, other._snmpTrapAddress) && Objects.equals(this._snmpTrapPort, other._snmpTrapPort) && Objects.equals(this._has_snmpTrapPort, other._has_snmpTrapPort) && Objects.equals(this._newSuspectOnTrap, other._newSuspectOnTrap) && Objects.equals(this._snmpv3UserList, other._snmpv3UserList) && Objects.equals(this._includeRawMessage, other._includeRawMessage) && Objects.equals(this._threads, other._threads) && Objects.equals(this._queueSize, other._queueSize) && Objects.equals(this._batchSize, other._batchSize) && Objects.equals(this._batchInterval, other._batchInterval) && Objects.equals(this._useAddessFromVarbind, other._useAddessFromVarbind);
            return equals;
        }
        return false;
    }

    public boolean getNewSuspectOnTrap() {
        return this._newSuspectOnTrap;
    }

    public String getSnmpTrapAddress() {
        return this._snmpTrapAddress;
    }

    public int getSnmpTrapPort() {
        return this._snmpTrapPort;
    }

    public Snmpv3User getSnmpv3User(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._snmpv3UserList.size()) {
            throw new IndexOutOfBoundsException("getSnmpv3User: Index value '" + index + "' not in range [0.." + (this._snmpv3UserList.size() - 1) + "]");
        }
        return this._snmpv3UserList.get(index);
    }

    public Snmpv3User[] getSnmpv3User() {
        Snmpv3User[] array = new Snmpv3User[]{};
        return this._snmpv3UserList.toArray(array);
    }

    public List<Snmpv3User> getSnmpv3UserCollection() {
        return this._snmpv3UserList;
    }

    public int getSnmpv3UserCount() {
        return this._snmpv3UserList.size();
    }

    public boolean hasNewSuspectOnTrap() {
        return this._has_newSuspectOnTrap;
    }

    public boolean hasSnmpTrapPort() {
        return this._has_snmpTrapPort;
    }

    public boolean isNewSuspectOnTrap() {
        return this._newSuspectOnTrap;
    }

    public boolean shouldUseAddressFromVarbind() {
        return this._useAddessFromVarbind != null ? this._useAddessFromVarbind : false;
    }

    public void setUseAddressFromVarbind(Boolean useAddessFromVarbind) {
        this._useAddessFromVarbind = useAddessFromVarbind;
    }

    public Iterator<Snmpv3User> iterateSnmpv3User() {
        return this._snmpv3UserList.iterator();
    }

    public void removeAllSnmpv3User() {
        this._snmpv3UserList.clear();
    }

    public boolean removeSnmpv3User(Snmpv3User vSnmpv3User) {
        boolean removed = this._snmpv3UserList.remove(vSnmpv3User);
        return removed;
    }

    public Snmpv3User removeSnmpv3UserAt(int index) {
        Snmpv3User obj = this._snmpv3UserList.remove(index);
        return obj;
    }

    public void setNewSuspectOnTrap(boolean newSuspectOnTrap) {
        this._newSuspectOnTrap = newSuspectOnTrap;
        this._has_newSuspectOnTrap = true;
    }

    public void setSnmpTrapAddress(String snmpTrapAddress) {
        this._snmpTrapAddress = snmpTrapAddress;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this._snmpTrapPort = snmpTrapPort;
        this._has_snmpTrapPort = true;
    }

    public void setSnmpv3User(int index, Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._snmpv3UserList.size()) {
            throw new IndexOutOfBoundsException("setSnmpv3User: Index value '" + index + "' not in range [0.." + (this._snmpv3UserList.size() - 1) + "]");
        }
        this._snmpv3UserList.set(index, vSnmpv3User);
    }

    public void setSnmpv3User(Snmpv3User[] vSnmpv3UserArray) {
        this._snmpv3UserList.clear();
        for (int i = 0; i < vSnmpv3UserArray.length; ++i) {
            this._snmpv3UserList.add(vSnmpv3UserArray[i]);
        }
    }

    public void setSnmpv3User(List<Snmpv3User> vSnmpv3UserList) {
        this._snmpv3UserList.clear();
        this._snmpv3UserList.addAll(vSnmpv3UserList);
    }

    public void setSnmpv3UserCollection(List<Snmpv3User> snmpv3UserList) {
        this._snmpv3UserList = snmpv3UserList;
    }

    public boolean isIncludeRawMessage() {
        return this._includeRawMessage;
    }

    public void setIncludeRawMessage(boolean _includeRawMessage) {
        this._includeRawMessage = _includeRawMessage;
    }

    public int getThreads() {
        return this._threads;
    }

    public void setThreads(int _threads) {
        this._threads = _threads;
    }

    public int getQueueSize() {
        return this._queueSize;
    }

    public void setQueueSize(int _queueSize) {
        this._queueSize = _queueSize;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int _batchSize) {
        this._batchSize = _batchSize;
    }

    public int getBatchInterval() {
        return this._batchInterval;
    }

    public void setBatchInterval(int _batchInterval) {
        this._batchInterval = _batchInterval;
    }
}

