/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.api.collection.IDataCollectionGroup;
import org.opennms.netmgt.config.api.collection.IGroupReference;
import org.opennms.netmgt.config.api.collection.ISnmpCollection;
import org.opennms.netmgt.config.internal.collection.DataCollectionGroupImpl;
import org.opennms.netmgt.config.internal.collection.GroupReferenceImpl;

@XmlRootElement(name="snmp-collection")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SnmpCollectionImpl
implements ISnmpCollection {
    @XmlAttribute(name="name")
    private String m_name = "default";
    @XmlElement(name="include-collection")
    private GroupReferenceImpl[] m_includedGroups;
    @XmlElement(name="datacollection-group")
    private DataCollectionGroupImpl[] m_dataCollectionGroups;

    public SnmpCollectionImpl() {
    }

    public SnmpCollectionImpl(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IGroupReference[] getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void addIncludedGroup(String groupName) {
        ArrayList<GroupReferenceImpl> groups = this.m_includedGroups == null ? new ArrayList<GroupReferenceImpl>() : new ArrayList<GroupReferenceImpl>(Arrays.asList(this.m_includedGroups));
        groups.add(new GroupReferenceImpl(groupName));
        this.m_includedGroups = groups.toArray(new GroupReferenceImpl[groups.size()]);
    }

    @Override
    public IDataCollectionGroup[] getDataCollectionGroups() {
        return this.m_dataCollectionGroups;
    }

    public void addDataCollectionGroup(DataCollectionGroupImpl group) {
        ArrayList<DataCollectionGroupImpl> groups = this.m_dataCollectionGroups == null ? new ArrayList<DataCollectionGroupImpl>() : new ArrayList<DataCollectionGroupImpl>(Arrays.asList(this.m_dataCollectionGroups));
        groups.add(group);
        this.m_dataCollectionGroups = groups.toArray(new DataCollectionGroupImpl[groups.size()]);
    }

    public String toString() {
        return "SnmpCollectionImpl [name=" + this.m_name + ", includedGroups=" + Arrays.toString(this.m_includedGroups) + ", dataCollectionGroups=" + Arrays.toString(this.m_dataCollectionGroups) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_dataCollectionGroups);
        result = 31 * result + Arrays.hashCode(this.m_includedGroups);
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnmpCollectionImpl)) {
            return false;
        }
        SnmpCollectionImpl other = (SnmpCollectionImpl)obj;
        if (!Arrays.equals(this.m_dataCollectionGroups, other.m_dataCollectionGroups)) {
            return false;
        }
        if (!Arrays.equals(this.m_includedGroups, other.m_includedGroups)) {
            return false;
        }
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }
}

