/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd.jmx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;

@XmlRootElement(name="jmx-datacollection-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JmxDatacollectionConfig
implements Serializable {
    @XmlAttribute(name="rrdRepository", required=true)
    private String _rrdRepository;
    @XmlElement(name="jmx-collection", required=true)
    private List<JmxCollection> _jmxCollectionList = new ArrayList<JmxCollection>();

    public void addJmxCollection(JmxCollection jmxCollection) {
        this._jmxCollectionList.add(jmxCollection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmxDatacollectionConfig) {
            JmxDatacollectionConfig temp = (JmxDatacollectionConfig)obj;
            boolean equals = Objects.equals(this._rrdRepository, temp._rrdRepository) && Objects.equals(this._jmxCollectionList, temp._jmxCollectionList);
            return equals;
        }
        return false;
    }

    public JmxCollection getJmxCollection(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._jmxCollectionList.size()) {
            throw new IndexOutOfBoundsException("getJmxCollection: Index value '" + index + "' not in range [0.." + (this._jmxCollectionList.size() - 1) + "]");
        }
        return this._jmxCollectionList.get(index);
    }

    public JmxCollection getJmxCollection(String collectionName) {
        for (JmxCollection eachCollection : this._jmxCollectionList) {
            if (eachCollection == null || eachCollection.getName() == null || !eachCollection.getName().equals(collectionName)) continue;
            return eachCollection;
        }
        return null;
    }

    public int getJmxCollectionCount() {
        return this._jmxCollectionList.size();
    }

    public String getRrdRepository() {
        return this._rrdRepository;
    }

    public int hashCode() {
        return Objects.hash(this._rrdRepository, this._jmxCollectionList);
    }

    public boolean removeJmxCollection(JmxCollection vJmxCollection) {
        boolean removed = this._jmxCollectionList.remove(vJmxCollection);
        return removed;
    }

    public void setJmxCollectionList(List<JmxCollection> jmxCollectionList) {
        this._jmxCollectionList.clear();
        this._jmxCollectionList.addAll(jmxCollectionList);
    }

    public List<JmxCollection> getJmxCollectionList() {
        return this._jmxCollectionList;
    }

    public void setRrdRepository(String rrdRepository) {
        this._rrdRepository = rrdRepository;
    }
}

