/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.asterisk;

import java.util.List;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.asterisk.utils.AsteriskOriginator;
import org.opennms.netmgt.asterisk.utils.AsteriskOriginatorException;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskOriginateNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskOriginateNotificationStrategy.class);

    public final int send(List<Argument> arguments) {
        LOG.debug("In the {} class", this.getClass());
        try {
            this.buildOriginator(arguments).originateCall();
        }
        catch (AsteriskOriginatorException aoe) {
            LOG.error("Error originating call for notification.", (Throwable)aoe);
            return 1;
        }
        return 0;
    }

    private AsteriskOriginator buildOriginator(List<Argument> arguments) throws AsteriskOriginatorException {
        AsteriskOriginator ao = new AsteriskOriginator();
        for (Argument arg : arguments) {
            String argSwitch = arg.getSwitch();
            String argValue = arg.getValue();
            if ("-wphone".equals(argSwitch)) {
                LOG.debug("Found: PARAM_WORK_PHONE => {}", (Object)argValue);
                ao.setLegAExtension(argValue);
                continue;
            }
            if ("-hphone".equals(argSwitch)) {
                LOG.debug("Found: PARAM_HOME_PHONE => {}", (Object)argValue);
                ao.setLegAExtension(argValue);
                continue;
            }
            if ("-mphone".equals(argSwitch)) {
                LOG.debug("Found: PARAM_MOBILE_PHONE => {}", (Object)argValue);
                ao.setLegAExtension(argValue);
                continue;
            }
            if ("-subject".equals(argSwitch)) {
                LOG.debug("Found: PARAM_SUBJECT => {}", (Object)argValue);
                ao.setSubject(argValue);
                ao.setChannelVariable("OPENNMS_NOTIFY_SUBJECT", argValue);
                continue;
            }
            if ("-tm".equals(argSwitch)) {
                LOG.debug("Found: PARAM_TEXT_MSG => {}", (Object)argValue);
                ao.setMessageText(argValue);
                ao.setChannelVariable("OPENNMS_NOTIFY_BODY", argValue);
                continue;
            }
            if ("-tuipin".equals(argSwitch)) {
                LOG.debug("Found: PARAM_TUI_PIN => {}", (Object)argValue);
                ao.setChannelVariable("OPENNMS_USER_PIN", argValue);
                continue;
            }
            if ("-d".equals(argSwitch)) {
                LOG.debug("Found: PARAM_DESTINATION => {}", (Object)argValue);
                ao.setChannelVariable("OPENNMS_USERNAME", argValue);
                continue;
            }
            if ("-nodeid".equals(argSwitch)) {
                LOG.debug("Found: PARAM_NODE => {}", (Object)argValue);
                ao.setChannelVariable("OPENNMS_NODEID", argValue);
                try {
                    NodeDao nodeDao = (NodeDao)BeanUtils.getBean((String)"notifdContext", (String)"nodeDao", NodeDao.class);
                    ao.setChannelVariable("OPENNMS_NODELABEL", nodeDao.get(argValue).getLabel());
                }
                catch (Throwable t) {
                    ao.setChannelVariable("OPENNMS_NODELABEL", null);
                }
                continue;
            }
            if ("-interface".equals(argSwitch)) {
                LOG.debug("Found: PARAM_INTERFACE => {}", (Object)argValue);
                ao.setChannelVariable("OPENNMS_INTERFACE", argValue);
                continue;
            }
            if ("-service".equals(argSwitch)) {
                LOG.debug("Found: PARAM_SERVICE => {}", (Object)argValue);
                ao.setChannelVariable("OPENNMS_SERVICE", argValue);
                continue;
            }
            LOG.debug("Unconsumed arg: {} => {}", (Object)String.valueOf(argSwitch), (Object)String.valueOf(argValue));
        }
        return ao;
    }
}

