/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.asterisk.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.DefaultManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.asterisk.utils.AsteriskConfig;
import org.opennms.netmgt.asterisk.utils.AsteriskOriginatorException;
import org.opennms.netmgt.asterisk.utils.AsteriskUtils;
import org.opennms.netmgt.config.AmiPeerFactory;
import org.opennms.netmgt.config.ami.AmiAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskOriginator {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskOriginator.class);
    private static final String DEFAULT_AMI_HOST = "127.0.0.1";
    private static final boolean DEFAULT_ORIGINATOR_DEBUG = true;
    private static final long DEFAULT_RESPONSE_TIMEOUT = 10000L;
    private static final String DEFAULT_LEGA_CALLER_ID = "OpenNMS<9195551212>";
    private static final long DEFAULT_LEGA_TIMEOUT = 30000L;
    private static final String DEFAULT_LEGA_CHANNEL_PATTERN = "Local/${exten}@default";
    private static final String DEFAULT_LEGB_CONTEXT = "default";
    private static final String DEFAULT_LEGB_EXTENSION = "noc";
    private static final int DEFAULT_LEGB_PRIORITY = 1;
    private DefaultManagerConnection m_managerConnection = null;
    private Properties m_amiProps;
    private boolean m_debug;
    private long m_responseTimeout;
    private InetAddress m_amiHost;
    private String m_legAChannelPattern;
    private String m_callerId;
    private long m_dialTimeout;
    private String m_legBContext;
    private int m_legBPriority;
    private String m_legBExtension;
    private boolean m_legBIsApp;
    private String m_legBAppPattern;
    private String m_legBAppDataPattern;
    private String m_legBApp;
    private String m_legBAppData;
    private String m_legAExtension;
    private String m_legAChannel;
    private String m_subject;
    private String m_messageText;
    private Map<String, String> m_channelVars;

    public AsteriskOriginator(Properties amiProps) throws AsteriskOriginatorException {
        try {
            this.configureProperties(amiProps);
        }
        catch (IOException e) {
            throw new AsteriskOriginatorException("Failed to construct originator", e);
        }
        try {
            AmiPeerFactory.init();
        }
        catch (IOException ioe) {
            throw new AsteriskOriginatorException("I/O error initializing AMI peer factory", ioe);
        }
        AmiAgentConfig agentConfig = AmiPeerFactory.getInstance().getAgentConfig(this.m_amiHost);
        ManagerConnectionFactory mcf = new ManagerConnectionFactory(InetAddressUtils.str((InetAddress)this.m_amiHost), ((Integer)agentConfig.getPort().orElse(null)).intValue(), (String)agentConfig.getUsername().orElse(null), (String)agentConfig.getPassword().orElse(null));
        this.m_managerConnection = agentConfig.getUseTls().orElse(false) != false ? (DefaultManagerConnection)mcf.createSecureManagerConnection() : (DefaultManagerConnection)mcf.createManagerConnection();
        this.m_managerConnection.setDefaultResponseTimeout(this.m_responseTimeout);
        this.m_channelVars = new HashMap<String, String>();
    }

    public AsteriskOriginator() throws AsteriskOriginatorException {
        this(new Properties());
    }

    private void configureProperties(Properties amiProps) throws IOException {
        this.m_amiProps = AsteriskConfig.getProperties();
        this.m_amiProps.putAll((Map<?, ?>)amiProps);
        this.m_debug = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.debug", (boolean)true);
        this.m_responseTimeout = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.responsetimeout", (long)10000L);
        this.m_amiHost = InetAddressUtils.addr((String)PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.amiHost", (String)DEFAULT_AMI_HOST));
        this.m_legAChannelPattern = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legachannel", (String)DEFAULT_LEGA_CHANNEL_PATTERN);
        this.m_callerId = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legacallerid", (String)DEFAULT_LEGA_CALLER_ID);
        this.m_dialTimeout = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legadialtimeout", (long)30000L);
        this.m_legBContext = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legbcontext", (String)DEFAULT_LEGB_CONTEXT);
        this.m_legBExtension = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legbextension", (String)DEFAULT_LEGB_EXTENSION);
        String legBPriorityStr = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legbpriority", (String)Integer.valueOf(1).toString());
        this.m_legBPriority = Integer.parseInt(legBPriorityStr);
        this.m_legBAppPattern = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legbapp", null);
        this.m_legBAppDataPattern = PropertiesUtils.getProperty((Properties)this.m_amiProps, (String)"org.opennms.asterisk.originate.legbappdata", null);
        this.m_legBIsApp = this.m_legBAppPattern != null && !"".equals(this.m_legBAppPattern.trim());
    }

    public void originateCall() throws AsteriskOriginatorException {
        OriginateAction originateAction = this.buildOriginateAction();
        LOG.info("Logging in Asterisk manager connection");
        try {
            this.m_managerConnection.login();
        }
        catch (IllegalStateException ise) {
            throw new AsteriskOriginatorException("Illegal state logging in Asterisk manager connection", ise);
        }
        catch (IOException ioe) {
            throw new AsteriskOriginatorException("I/O exception logging in Asterisk manager connection", ioe);
        }
        catch (AuthenticationFailedException afe) {
            throw new AsteriskOriginatorException("Authentication failure logging in Asterisk manager connection", afe);
        }
        catch (TimeoutException toe) {
            throw new AsteriskOriginatorException("Timed out logging in Asterisk manager connection", toe);
        }
        LOG.info("Successfully logged in Asterisk manager connection");
        LOG.info("Originating a call to extension {}", (Object)this.m_legAExtension);
        LOG.debug(this.createCallLogMsg());
        LOG.debug("Originate action:\n\n{}", (Object)originateAction.toString());
        ManagerResponse managerResponse = null;
        try {
            managerResponse = this.m_managerConnection.sendAction((ManagerAction)originateAction);
        }
        catch (IllegalArgumentException iae) {
            this.m_managerConnection.logoff();
            throw new AsteriskOriginatorException("Illegal argument sending originate action", iae);
        }
        catch (IllegalStateException ise) {
            this.m_managerConnection.logoff();
            throw new AsteriskOriginatorException("Illegal state sending originate action", ise);
        }
        catch (IOException ioe) {
            this.m_managerConnection.logoff();
            throw new AsteriskOriginatorException("I/O exception sending originate action", ioe);
        }
        catch (TimeoutException toe) {
            this.m_managerConnection.logoff();
            throw new AsteriskOriginatorException("Timed out sending originate action", toe);
        }
        LOG.info("Asterisk manager responded: {}", (Object)managerResponse.getResponse());
        LOG.info("Asterisk manager message: {}", (Object)managerResponse.getMessage());
        if (managerResponse.getResponse().toLowerCase().startsWith("error")) {
            this.m_managerConnection.logoff();
            throw new AsteriskOriginatorException("Got error response sending originate event. Response: " + managerResponse.getResponse() + "; Message: " + managerResponse.getMessage());
        }
        LOG.info("Logging off Asterisk manager connection");
        this.m_managerConnection.logoff();
        LOG.info("Successfully logged off Asterisk manager connection");
    }

    public OriginateAction buildOriginateAction() throws AsteriskOriginatorException {
        OriginateAction action = new OriginateAction();
        action.setCallerId(this.m_callerId);
        this.setLegAChannel(this.expandPattern(this.m_legAChannelPattern));
        action.setChannel(this.getLegAChannel());
        action.setTimeout(Long.valueOf(this.m_dialTimeout));
        action.setCallerId(this.m_callerId);
        if (this.m_legBIsApp) {
            action.setApplication(this.expandPattern(this.m_legBAppPattern));
            action.setData(this.expandPattern(this.m_legBAppDataPattern));
        } else {
            action.setContext(this.m_legBContext);
            action.setExten(this.m_legBExtension);
            action.setPriority(Integer.valueOf(this.m_legBPriority));
        }
        action.setVariables(this.m_channelVars);
        return action;
    }

    private String expandPattern(String pattern) {
        LOG.debug("Expanding pattern {}", (Object)pattern);
        Properties props = new Properties();
        props.put("exten", this.getLegAExtension());
        String expanded = PropertiesUtils.substitute((String)AsteriskUtils.expandPattern(pattern), (Properties[])new Properties[]{props});
        LOG.debug("Expanded pattern is: {}", (Object)expanded);
        return expanded;
    }

    private String createCallLogMsg() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tChannel: ");
        sb.append(this.getLegAChannel());
        sb.append("\n\tFrom Caller-ID: ");
        sb.append(this.getCallerId());
        if (this.m_legBIsApp) {
            sb.append("\n\tConnect to application: ");
            sb.append(this.m_legBApp);
            sb.append("\n\tApplication Data: ");
            sb.append(this.m_legBAppData);
        } else {
            sb.append("\n\tConnect to extension: ");
            sb.append(this.m_legBExtension);
            sb.append("\n\tIn context: ");
            sb.append(this.m_legBContext);
            sb.append("\n\tStarting at priority: ");
            sb.append(this.m_legBPriority);
        }
        sb.append("\n\tSubject is: ");
        sb.append(this.getSubject());
        sb.append("\n\n");
        sb.append(this.getMessageText());
        sb.append("\n");
        return sb.toString();
    }

    public String getCallerId() {
        return this.m_callerId;
    }

    public void setCallerId(String cid) {
        this.m_callerId = cid;
    }

    public String getAmiHost() {
        return InetAddressUtils.str((InetAddress)this.m_amiHost);
    }

    public void setAmiHost(String amiHost) throws UnknownHostException {
        this.m_amiHost = InetAddressUtils.addr((String)amiHost);
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public void setMessageText(String messageText) {
        this.m_messageText = messageText;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getLegAExtension() {
        return this.m_legAExtension;
    }

    public void setLegAExtension(String exten) {
        this.m_legAExtension = exten;
    }

    public String getLegAChannel() {
        return this.m_legAChannel;
    }

    public void setLegAChannel(String chan) {
        this.m_legAChannel = chan;
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public Properties getAmiProps() {
        return this.m_amiProps;
    }

    public void setChannelVariable(String name, String value) {
        this.m_channelVars.put(name, value);
    }

    public Map<String, String> getChannelVariables() {
        return Collections.unmodifiableMap(this.m_channelVars);
    }

    public String getChannelVariable(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        return this.m_channelVars.get(name);
    }
}

