/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.asterisk.utils.AsteriskOriginator;
import org.opennms.netmgt.asterisk.utils.AsteriskOriginatorException;
import org.opennms.netmgt.notifd.Notifd;
import org.opennms.netmgt.notifd.NotificationStrategy;

public class AsteriskOriginateNotificationStrategy
implements NotificationStrategy {
    public int send(List<Argument> arguments) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("In the " + this.getClass() + " class");
        }
        try {
            AsteriskOriginator originator = this.buildOriginator(arguments);
            originator.originateCall();
        }
        catch (AsteriskOriginatorException aoe) {
            this.log().error("Error originating call for notification.", (Throwable)aoe);
            return 1;
        }
        return 0;
    }

    private AsteriskOriginator buildOriginator(List<Argument> arguments) throws AsteriskOriginatorException {
        AsteriskOriginator ao = new AsteriskOriginator();
        for (Argument arg : arguments) {
            if ("-wphone".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_WORK_PHONE => " + arg.getValue());
                ao.setLegAExtension(arg.getValue());
                continue;
            }
            if ("-hphone".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_HOME_PHONE => " + arg.getValue());
                ao.setLegAExtension(arg.getValue());
                continue;
            }
            if ("-mphone".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_MOBILE_PHONE => " + arg.getValue());
                ao.setLegAExtension(arg.getValue());
                continue;
            }
            if ("-subject".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_SUBJECT => " + arg.getValue());
                ao.setSubject(arg.getValue());
                ao.setChannelVariable("OPENNMS_NOTIFY_SUBJECT", arg.getValue());
                continue;
            }
            if ("-tm".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_TEXT_MSG => " + arg.getValue());
                ao.setMessageText(arg.getValue());
                ao.setChannelVariable("OPENNMS_NOTIFY_BODY", arg.getValue());
                continue;
            }
            if ("-tuipin".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_TUI_PIN => " + arg.getValue());
                ao.setChannelVariable("OPENNMS_USER_PIN", arg.getValue());
                continue;
            }
            if ("-d".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_DESTINATION => " + arg.getValue());
                ao.setChannelVariable("OPENNMS_USERNAME", arg.getValue());
                continue;
            }
            if ("-nodeid".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_NODE => " + arg.getValue());
                ao.setChannelVariable("OPENNMS_NODEID", arg.getValue());
                try {
                    ao.setChannelVariable("OPENNMS_NODELABEL", Notifd.getInstance().getNodeDao().get(arg.getValue()).getLabel());
                }
                catch (Throwable e) {
                    ao.setChannelVariable("OPENNMS_NODELABEL", null);
                }
                continue;
            }
            if ("-interface".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_INTERFACE => " + arg.getValue());
                ao.setChannelVariable("OPENNMS_INTERFACE", arg.getValue());
                continue;
            }
            if ("-service".equals(arg.getSwitch())) {
                this.log().debug("Found: PARAM_SERVICE => " + arg.getValue());
                ao.setChannelVariable("OPENNMS_SERVICE", arg.getValue());
                continue;
            }
            this.log().debug("Unconsumed arg: " + String.valueOf(arg.getSwitch()) + " => " + String.valueOf(arg.getValue()));
        }
        return ao;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

