/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.core.ClockType;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.io.ResourceFactory;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.alarmd.drools.DroolsAlarmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedDroolsContext {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsAlarmContext.class);
    private static final String JMX_DOMAIN_PREFIX = "org.opennms.features.drools.";
    private static final long LIVENESS_CHECK_INTERVAL_MS = SystemProperties.getLong((String)"org.opennms.netmgt.alarmd.drools.liveness_check_interval_ms", (Long)TimeUnit.SECONDS.toMillis(30L));
    private final MetricRegistry metrics;
    private final File rulesFolder;
    private final String kbaseName;
    private final String kSessionName;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private boolean usePseudoClock = false;
    private boolean useManualTick = false;
    private ReleaseId releaseIdForContainerUsedByKieSession;
    private KieContainer kieContainer;
    private KieSession kieSession;
    private Thread thread;
    private SessionPseudoClock clock;
    protected AtomicLong fireThreadId = new AtomicLong(-1L);
    private Consumer<KieSession> onNewKiewSessionCallback;
    private JmxReporter metricsReporter;
    private Timer livenessTimer;
    private com.codahale.metrics.Timer livenessTimerMetric;

    public ManagedDroolsContext(File rulesFolder, String kbaseName, String kSessionSuffixName) {
        this.rulesFolder = Objects.requireNonNull(rulesFolder);
        this.kbaseName = Objects.requireNonNull(kbaseName);
        this.kSessionName = String.format("%s-%s", kbaseName, Objects.requireNonNull(kSessionSuffixName));
        this.metrics = new MetricRegistry();
        this.metrics.register("facts", (Metric)((Gauge)() -> this.kieSession != null ? this.kieSession.getFactCount() : -1L));
        this.livenessTimerMetric = this.metrics.timer("liveness");
    }

    public synchronized void start() {
        if (this.started.get()) {
            LOG.warn("The context for session {} is already started. Ignoring start request.", (Object)this.kSessionName);
            return;
        }
        ReleaseId kieModuleReleaseId = this.buildKieModule();
        this.startWithModuleAndFacts(kieModuleReleaseId, Collections.emptyList());
        this.metricsReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).inDomain(JMX_DOMAIN_PREFIX + this.kbaseName).build();
        try {
            this.metricsReporter.start();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to start metrics reporter. JMX metrics may not be available or accurate for kbase: {}", (Object)this.kbaseName);
        }
    }

    public void onStart() {
    }

    private void startWithModuleAndFacts(ReleaseId releaseId, List<Object> factObjects) {
        KieServices ks = KieServices.Factory.get();
        this.kieContainer = ks.newKieContainer(releaseId);
        this.kieSession = this.kieContainer.newKieSession(this.kSessionName);
        if (this.usePseudoClock) {
            this.clock = (SessionPseudoClock)this.kieSession.getSessionClock();
        }
        this.kieSession.insert((Object)this.kieSession.getSessionClock());
        factObjects.forEach(factObject -> this.kieSession.insert(factObject));
        if (this.onNewKiewSessionCallback != null) {
            this.onNewKiewSessionCallback.accept(this.kieSession);
        }
        this.releaseIdForContainerUsedByKieSession = releaseId;
        this.started.set(true);
        this.livenessTimer = new Timer();
        this.livenessTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (ManagedDroolsContext.this.kieSession != null) {
                        Timer.Context ctx = ManagedDroolsContext.this.livenessTimerMetric.time();
                        CountDownLatch latch = new CountDownLatch(1);
                        ManagedDroolsContext.this.kieSession.submit(kieSession -> {
                            latch.countDown();
                            ctx.close();
                        });
                        latch.await();
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception occurred while performing liveness check.", (Throwable)e);
                }
            }
        }, LIVENESS_CHECK_INTERVAL_MS, LIVENESS_CHECK_INTERVAL_MS);
        this.onStart();
        if (!this.useManualTick) {
            this.thread = new Thread(() -> {
                this.fireThreadId.set(Thread.currentThread().getId());
                while (this.started.get()) {
                    try {
                        LOG.debug("Firing until halt.");
                        this.kieSession.fireUntilHalt();
                    }
                    catch (Exception e) {
                        if (this.started.get()) {
                            LOG.error("Error occurred while firing rules. Waiting 30 seconds before starting to fire again.", (Throwable)e);
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
                                continue;
                            }
                            catch (InterruptedException ex) {
                                LOG.warn("Interrupted while waiting to start firing rules again. Exiting thread.");
                                return;
                            }
                        }
                        LOG.warn("Encountered exception while firing rules, but the engine is stopped. Exiting thread.", (Throwable)e);
                        return;
                    }
                }
            });
            this.thread.setName("DroolsSession-" + this.kSessionName);
            this.thread.start();
        }
    }

    public synchronized void reload() {
        if (!this.started.get()) {
            LOG.warn("The context for session {} is not yet started. Treating reload as a start request", (Object)this.kSessionName);
            this.start();
            return;
        }
        ReleaseId releaseId = this.buildKieModule();
        this.started.set(false);
        if (!this.useManualTick) {
            this.kieSession.halt();
            try {
                this.thread.join(TimeUnit.MINUTES.toMillis(2L));
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for session to halt. Aborting reload request.");
                return;
            }
            if (this.thread.isAlive()) {
                LOG.warn("Thread is still alive! Interrupting.");
                this.thread.interrupt();
            }
        }
        List<Object> factObjects = this.kieSession.getFactHandles().stream().map(arg_0 -> ((KieSession)this.kieSession).getObject(arg_0)).filter(o -> !(o instanceof SessionClock)).collect(Collectors.toList());
        this.kieSession.dispose();
        if (this.releaseIdForContainerUsedByKieSession != null) {
            if (KieServices.Factory.get().getRepository().removeKieModule(this.releaseIdForContainerUsedByKieSession) != null) {
                LOG.info("Successfully removed previous KIE module with ID: {}.", (Object)this.releaseIdForContainerUsedByKieSession);
            } else {
                LOG.info("Previous KIE module was with ID: {} was already removed.", (Object)this.releaseIdForContainerUsedByKieSession);
            }
            this.releaseIdForContainerUsedByKieSession = null;
        }
        this.startWithModuleAndFacts(releaseId, factObjects);
    }

    private ReleaseId buildKieModule() {
        List<File> rulesFiles;
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ManagedDroolsContext.generateReleaseId();
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel base = module.newKieBaseModel(this.kbaseName);
        base.setDefault(true);
        base.addPackage("*");
        base.setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel kieSessionModel = base.newKieSessionModel(this.kSessionName).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL);
        if (this.usePseudoClock) {
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        }
        LOG.debug("kmodule.xml: {}", (Object)module.toXML());
        kfs.writeKModuleXML(module.toXML());
        kfs.generateAndWritePomXML(id);
        try {
            rulesFiles = this.getRulesFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Using rules files: {}", rulesFiles);
        for (File file : rulesFiles) {
            kfs.write("src/main/resources/" + file.getName(), ResourceFactory.newFileResource((File)file));
        }
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        LOG.info("Successfully built KIE module with ID: {}.", (Object)id);
        return id;
    }

    private List<File> getRulesFiles() throws IOException {
        Path droolsRulesRoot = this.rulesFolder.toPath();
        if (!droolsRulesRoot.toFile().isDirectory()) {
            throw new IllegalStateException("Expected to find Drools rules for alarmd in '" + droolsRulesRoot + "' but the path is not a directory! Aborting.");
        }
        return Files.find(droolsRulesRoot, 3, (path, attrs) -> attrs.isRegularFile() && path.toString().endsWith(".drl"), new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private static ReleaseId generateReleaseId() {
        KieServices ks = KieServices.Factory.get();
        String moduleName = UUID.randomUUID().toString();
        return ks.newReleaseId(ManagedDroolsContext.class.getPackage().getName(), moduleName, "1.0.0");
    }

    public void tick() {
        this.kieSession.fireAllRules();
    }

    public synchronized void stop() {
        this.started.set(false);
        if (this.metricsReporter != null) {
            this.metricsReporter.close();
        }
        if (this.livenessTimer != null) {
            this.livenessTimer.cancel();
            this.livenessTimer = null;
        }
        if (this.kieSession != null) {
            this.kieSession.halt();
            this.kieSession = null;
        }
        if (this.kieContainer != null) {
            this.kieContainer.dispose();
            this.kieContainer = null;
        }
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                long waitMillis = TimeUnit.MINUTES.toMillis(2L);
                this.thread.join(waitMillis);
                if (this.thread.isAlive()) {
                    LOG.error("Thread is still alive after waiting for {}ms.", (Object)waitMillis);
                }
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while waiting for thread to exit.");
            }
            this.thread = null;
        }
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public SessionPseudoClock getClock() {
        return this.clock;
    }

    public boolean isUsePseudoClock() {
        return this.usePseudoClock;
    }

    public void setUsePseudoClock(boolean usePseudoClock) {
        this.usePseudoClock = usePseudoClock;
    }

    public void setUseManualTick(boolean useManualTick) {
        this.useManualTick = useManualTick;
    }

    public void setOnNewKiewSessionCallback(Consumer<KieSession> onNewKiewSessionCallback) {
        this.onNewKiewSessionCallback = onNewKiewSessionCallback;
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }
}

