/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

public class SessionClock
implements SessionPseudoClock {
    private static final Pattern TIME_PERIOD_PATTERN = Pattern.compile("\\s*(\\d+)([smhd])\\s*");
    private LoadingCache<String, Long> timePeriodToMsCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String timePeriod) {
            return SessionClock.getMsFromTimePeriod(timePeriod);
        }
    });
    private final KieSession session;
    private long now;
    private FactHandle handle;

    public SessionClock(KieSession session, long now) {
        this.session = Objects.requireNonNull(session);
        this.now = now;
        this.handle = session.insert((Object)this);
    }

    public long getCurrentTime() {
        return this.now;
    }

    public long advanceTime(long amount, TimeUnit unit) {
        this.now += unit.toMillis(amount);
        this.afterTimeChange();
        return this.now;
    }

    public void advanceTimeToNow() {
        this.now = System.currentTimeMillis();
        this.afterTimeChange();
    }

    public Date now() {
        return new Date(this.now);
    }

    public Date ago(String timePeriod) {
        try {
            return this.ago((Long)this.timePeriodToMsCache.get((Object)timePeriod), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Date ago(long amount, TimeUnit unit) {
        return new Date(this.now - unit.toMillis(amount));
    }

    private void afterTimeChange() {
        this.session.update(this.handle, (Object)this);
    }

    public static long getMsFromTimePeriod(String timePeriod) {
        String unit;
        if (timePeriod == null) {
            return 0L;
        }
        Matcher m = TIME_PERIOD_PATTERN.matcher(timePeriod);
        if (!m.matches()) {
            return 0L;
        }
        long amount = Long.parseLong(m.group(1));
        switch (unit = m.group(2)) {
            case "s": {
                return TimeUnit.SECONDS.toMillis(amount);
            }
            case "m": {
                return TimeUnit.MINUTES.toMillis(amount);
            }
            case "h": {
                return TimeUnit.HOURS.toMillis(amount);
            }
            case "d": {
                return TimeUnit.DAYS.toMillis(amount);
            }
        }
        return 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper(SessionClock.class).add("now", this.now).toString();
    }
}

