/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.alarmd.drools.AlarmService;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAlarmService
implements AlarmService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmService.class);
    protected static final String DEFAULT_USER = "admin";
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private AcknowledgmentDao acknowledgmentDao;
    @Autowired
    private AlarmEntityNotifier alarmEntityNotifier;
    @Autowired
    private EventForwarder eventForwarder;

    @Override
    @Transactional
    public void clearAlarm(OnmsAlarm alarm, Date clearTime) {
        LOG.info("Clearing alarm with id: {} with current severity: {} at: {}", new Object[]{alarm.getId(), alarm.getSeverity(), clearTime});
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping clear.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.CLEARED);
        DefaultAlarmService.updateAutomationTime(alarmInTrans, clearTime);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void deleteAlarm(OnmsAlarm alarm) {
        LOG.info("Deleting alarm with id: {} with severity: {}", (Object)alarm.getId(), (Object)alarm.getSeverity());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping delete.", (Object)alarm);
            return;
        }
        HashMap priorRelatedAlarms = new HashMap();
        if (alarmInTrans.isPartOfSituation()) {
            for (OnmsAlarm onmsAlarm : alarmInTrans.getRelatedSituations()) {
                priorRelatedAlarms.put(onmsAlarm, new HashSet(onmsAlarm.getRelatedAlarms()));
            }
        }
        this.alarmDao.delete((Object)alarmInTrans);
        for (Map.Entry entry : priorRelatedAlarms.entrySet()) {
            this.alarmEntityNotifier.didUpdateRelatedAlarms((OnmsAlarm)entry.getKey(), (Set)entry.getValue());
        }
        this.alarmEntityNotifier.didDeleteAlarm(alarmInTrans);
    }

    @Override
    @Transactional
    public void unclearAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Un-clearing alarm with id: {} at: {}", (Object)alarm.getId(), (Object)alarm.getLastEventTime());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping un-clear.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.get((int)alarmInTrans.getLastEvent().getEventSeverity()));
        DefaultAlarmService.updateAutomationTime(alarmInTrans, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void escalateAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Escalating alarm with id: {}", (Object)alarm.getId());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping escalate.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.get((int)(previousSeverity.getId() + 1)));
        DefaultAlarmService.updateAutomationTime(alarmInTrans, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void acknowledgeAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Acknowledging alarm with id: {} @ {}", (Object)alarm.getId(), (Object)now);
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping ack.", (Object)alarm);
            return;
        }
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarmInTrans, DEFAULT_USER, now);
        ack.setAckAction(AckAction.ACKNOWLEDGE);
        this.acknowledgmentDao.processAck(ack);
    }

    @Override
    @Transactional
    public void unacknowledgeAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Un-Acknowledging alarm with id: {} @ {}", (Object)alarm.getId(), (Object)now);
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping un-ack.", (Object)alarm);
            return;
        }
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarmInTrans, DEFAULT_USER, now);
        ack.setAckAction(AckAction.UNACKNOWLEDGE);
        this.acknowledgmentDao.processAck(ack);
    }

    @Override
    @Transactional
    public void setSeverity(OnmsAlarm alarm, OnmsSeverity severity, Date now) {
        LOG.info("Updating severity {} on alarm with id: {}", (Object)severity, (Object)alarm.getId());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping severity update.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(severity);
        DefaultAlarmService.updateAutomationTime(alarm, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    public void sendEvent(Event e) {
        this.eventForwarder.sendNow(e);
    }

    private static void updateAutomationTime(OnmsAlarm alarm, Date now) {
        if (alarm.getFirstAutomationTime() == null) {
            alarm.setFirstAutomationTime(now);
        }
        alarm.setLastAutomationTime(now);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.alarmDao = alarmDao;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.acknowledgmentDao = acknowledgmentDao;
    }

    public void setAlarmEntityNotifier(AlarmEntityNotifier alarmEntityNotifier) {
        this.alarmEntityNotifier = alarmEntityNotifier;
    }

    @Override
    public void debug(String message, Object ... objects) {
        LOG.debug(message, objects);
    }

    @Override
    public void info(String message, Object ... objects) {
        LOG.info(message, objects);
    }

    @Override
    public void warn(String message, Object ... objects) {
        LOG.warn(message, objects);
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }
}

