/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.alarmd.drools.AlarmAcknowledgementAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmService;
import org.opennms.netmgt.alarmd.drools.AlarmTicketerService;
import org.opennms.netmgt.alarmd.drools.ManagedDroolsContext;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DroolsAlarmContext
extends ManagedDroolsContext
implements AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsAlarmContext.class);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AcknowledgmentDao acknowledgmentDao;
    @Autowired
    private AlarmTicketerService alarmTicketerService;
    private final Map<Integer, AlarmAndFact> alarmsById = new HashMap<Integer, AlarmAndFact>();
    private final Map<Integer, AlarmAcknowledgementAndFact> acknowledgementsByAlarmId = new HashMap<Integer, AlarmAcknowledgementAndFact>();

    public DroolsAlarmContext() {
        super(Paths.get(ConfigFileConstants.getHome(), "etc", "alarmd", "drools-rules.d").toFile(), "alarmd", "DroolsAlarmContext");
        this.setOnNewKiewSessionCallback(kieSession -> {
            kieSession.setGlobal("alarmService", (Object)this.alarmService);
            kieSession.insert((Object)this.alarmTicketerService);
            this.alarmsById.clear();
            for (FactHandle fact : kieSession.getFactHandles()) {
                Object objForFact = kieSession.getObject(fact);
                if (!(objForFact instanceof OnmsAlarm)) continue;
                OnmsAlarm alarmInSession = (OnmsAlarm)objForFact;
                this.alarmsById.put(alarmInSession.getId(), new AlarmAndFact(alarmInSession, fact));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarmSnapshot(List<OnmsAlarm> alarms) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring alarm snapshot. Drools session is stopped.");
            return;
        }
        this.lockIfNotFiring();
        try {
            LOG.debug("Handling snapshot for {} alarms.", (Object)alarms.size());
            Map<Integer, OnmsAlarm> alarmsInDbById = alarms.stream().filter(a -> a.getId() != null).collect(Collectors.toMap(OnmsAlarm::getId, a -> a));
            Set<Integer> alarmIdsInDb = alarmsInDbById.keySet();
            Set<Integer> alarmIdsInWorkingMem = this.alarmsById.keySet();
            ImmutableSet alarmIdsToAdd = Sets.difference(alarmIdsInDb, alarmIdsInWorkingMem).immutableCopy();
            ImmutableSet alarmIdsToRemove = Sets.difference(alarmIdsInWorkingMem, alarmIdsInDb).immutableCopy();
            ImmutableSet alarmIdsToUpdate = Sets.intersection(alarmIdsInWorkingMem, alarmIdsInDb).immutableCopy();
            for (Integer alarmIdToRemove : alarmIdsToRemove) {
                this.handleDeletedAlarmNoLock(alarmIdToRemove);
            }
            for (Integer alarmIdToAdd : alarmIdsToAdd) {
                this.handleNewOrUpdatedAlarmNoLock(alarmsInDbById.get(alarmIdToAdd));
            }
            for (Integer alarmIdToUpdate : alarmIdsToUpdate) {
                this.handleNewOrUpdatedAlarmNoLock(alarmsInDbById.get(alarmIdToUpdate));
            }
        }
        finally {
            this.unlockIfNotFiring();
        }
    }

    public void handleNewOrUpdatedAlarm(OnmsAlarm alarm) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring new/updated alarm. Drools session is stopped.");
            return;
        }
        this.lockIfNotFiring();
        try {
            this.handleNewOrUpdatedAlarmNoLock(alarm);
        }
        finally {
            this.unlockIfNotFiring();
        }
    }

    private void handleNewOrUpdatedAlarmNoLock(OnmsAlarm alarm) {
        KieSession kieSession = this.getKieSession();
        Hibernate.initialize((Object)alarm.getAssociatedAlarms());
        AlarmAndFact alarmAndFact = this.alarmsById.get(alarm.getId());
        if (alarmAndFact == null) {
            LOG.debug("Inserting alarm into session: {}", (Object)alarm);
            FactHandle fact = this.getKieSession().insert((Object)alarm);
            this.alarmsById.put(alarm.getId(), new AlarmAndFact(alarm, fact));
        } else {
            LOG.trace("Deleting alarm from session (for re-insertion): {}", (Object)alarm);
            kieSession.delete(alarmAndFact.getFact());
            LOG.trace("Re-inserting alarm into session: {}", (Object)alarm);
            FactHandle fact = kieSession.insert((Object)alarm);
            alarmAndFact.setFact(fact);
        }
        this.handleAlarmAcknowledgements(alarm);
    }

    public void handleDeletedAlarm(int alarmId, String reductionKey) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring deleted alarm. Drools session is stopped.");
            return;
        }
        this.lockIfNotFiring();
        try {
            this.handleDeletedAlarmNoLock(alarmId);
        }
        finally {
            this.unlockIfNotFiring();
        }
    }

    private void handleAlarmAcknowledgements(OnmsAlarm alarm) {
        AlarmAcknowledgementAndFact acknowledgmentFact = this.acknowledgementsByAlarmId.get(alarm.getId());
        KieSession kieSession = this.getKieSession();
        if (acknowledgmentFact == null) {
            OnmsAcknowledgment ack = this.getLatestAcknowledgement(alarm);
            LOG.debug("Inserting first alarm acknowledgement into session: {}", (Object)ack);
            FactHandle fact = kieSession.insert((Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        } else {
            FactHandle fact = acknowledgmentFact.getFact();
            OnmsAcknowledgment ack = this.getLatestAcknowledgement(alarm);
            LOG.trace("Inserting acknowledgment into session: {}", (Object)ack);
            kieSession.update(fact, (Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        }
    }

    private OnmsAcknowledgment getLatestAcknowledgement(OnmsAlarm alarm) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAcknowledgment.class).eq("refId", (Object)alarm.getId()).limit(Integer.valueOf(1)).orderBy("ackTime").desc().orderBy("id").desc();
        List acks = this.acknowledgmentDao.findMatching(builder.toCriteria());
        if (acks.isEmpty()) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "admin", alarm.getFirstEventTime());
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
            ack.setId(Integer.valueOf(0));
            return ack;
        }
        return (OnmsAcknowledgment)acks.get(0);
    }

    private void handleDeletedAlarmNoLock(int alarmId) {
        AlarmAndFact alarmAndFact = this.alarmsById.remove(alarmId);
        if (alarmAndFact != null) {
            LOG.debug("Deleting alarm from session: {}", (Object)alarmAndFact.getAlarm());
            this.getKieSession().delete(alarmAndFact.getFact());
        }
        this.deleteAlarmAcknowledgement(alarmId);
    }

    private void deleteAlarmAcknowledgement(int alarmId) {
        AlarmAcknowledgementAndFact acknowledgmentFact = this.acknowledgementsByAlarmId.remove(alarmId);
        if (acknowledgmentFact != null) {
            LOG.debug("Deleting ack from session: {}", (Object)acknowledgmentFact.getAcknowledgement());
            this.getKieSession().delete(acknowledgmentFact.getFact());
        }
    }

    public void setAlarmService(AlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.acknowledgmentDao = acknowledgmentDao;
    }

    public void setAlarmTicketerService(AlarmTicketerService alarmTicketerService) {
        this.alarmTicketerService = alarmTicketerService;
    }
}

