/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.core.ClockType;
import org.drools.core.time.SessionPseudoClock;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;
import org.opennms.netmgt.alarmd.drools.DroolsAlarmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedDroolsContext {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsAlarmContext.class);
    private final File rulesFolder;
    private final String kbaseName;
    private final String kSessionName;
    private boolean started = false;
    private boolean usePseudoClock = false;
    private boolean useManualTick = false;
    private ReleaseId releaseIdForContainerUsedByKieSession;
    private KieContainer kieContainer;
    private KieSession kieSession;
    private Timer timer;
    private SessionPseudoClock clock;
    private final Lock lock = new ReentrantLock();
    private final ThreadLocal<Boolean> firing = new ThreadLocal();
    private Consumer<KieSession> onNewKiewSessionCallback;

    public ManagedDroolsContext(File rulesFolder, String kbaseName, String kSessionSuffixName) {
        this.rulesFolder = Objects.requireNonNull(rulesFolder);
        this.kbaseName = Objects.requireNonNull(kbaseName);
        this.kSessionName = String.format("%s-%s", kbaseName, Objects.requireNonNull(kSessionSuffixName));
    }

    public synchronized void start() {
        if (this.started) {
            LOG.warn("The context for session {} is already started. Ignoring start request.", (Object)this.kSessionName);
            return;
        }
        ReleaseId kieModuleReleaseId = this.buildKieModule();
        this.startWithModuleAndFacts(kieModuleReleaseId, Collections.emptyList());
    }

    private void startWithModuleAndFacts(ReleaseId releaseId, List<Object> factObjects) {
        KieServices ks = KieServices.Factory.get();
        this.kieContainer = ks.newKieContainer(releaseId);
        this.kieSession = this.kieContainer.newKieSession(this.kSessionName);
        this.clock = this.usePseudoClock ? (SessionPseudoClock)this.kieSession.getSessionClock() : null;
        factObjects.forEach(factObject -> this.kieSession.insert(factObject));
        if (this.onNewKiewSessionCallback != null) {
            this.onNewKiewSessionCallback.accept(this.kieSession);
        }
        if (!this.useManualTick) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ManagedDroolsContext.this.firing.set(true);
                    ManagedDroolsContext.this.lock.lock();
                    try {
                        LOG.debug("Firing rules.");
                        ManagedDroolsContext.this.kieSession.fireAllRules();
                    }
                    catch (Exception e) {
                        LOG.error("Error occurred while firing rules.", (Throwable)e);
                    }
                    finally {
                        ManagedDroolsContext.this.firing.set(false);
                        ManagedDroolsContext.this.lock.unlock();
                    }
                }
            }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
        }
        this.releaseIdForContainerUsedByKieSession = releaseId;
        this.started = true;
    }

    public synchronized void reload() {
        if (!this.started) {
            LOG.warn("The context for session {} is not yet started. Treating reload as a start request", (Object)this.kSessionName);
            this.start();
            return;
        }
        ReleaseId releaseId = this.buildKieModule();
        this.lock.lock();
        try {
            List<Object> factObjects = this.kieSession.getFactHandles().stream().map(fact -> this.kieSession.getObject(fact)).collect(Collectors.toList());
            this.stop();
            if (this.releaseIdForContainerUsedByKieSession != null) {
                if (KieServices.Factory.get().getRepository().removeKieModule(this.releaseIdForContainerUsedByKieSession) != null) {
                    LOG.info("Successfully removed previous KIE module with ID: {}.", (Object)this.releaseIdForContainerUsedByKieSession);
                } else {
                    LOG.info("Previous KIE module was with ID: {} was already removed.", (Object)this.releaseIdForContainerUsedByKieSession);
                }
                this.releaseIdForContainerUsedByKieSession = null;
            }
            this.startWithModuleAndFacts(releaseId, factObjects);
        }
        finally {
            this.lock.unlock();
        }
    }

    private ReleaseId buildKieModule() {
        List<File> rulesFiles;
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ManagedDroolsContext.generateReleaseId();
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel base = module.newKieBaseModel(this.kbaseName);
        base.setDefault(true);
        base.addPackage("*");
        base.setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel kieSessionModel = base.newKieSessionModel(this.kSessionName).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL);
        if (this.usePseudoClock) {
            kieSessionModel.setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        }
        LOG.debug("kmodule.xml: {}", (Object)module.toXML());
        kfs.writeKModuleXML(module.toXML());
        kfs.generateAndWritePomXML(id);
        try {
            rulesFiles = this.getRulesFiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOG.info("Using rules files: {}", rulesFiles);
        for (File file : rulesFiles) {
            kfs.write(ResourceFactory.newFileResource((File)file));
        }
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        LOG.info("Successfully built KIE module with ID: {}.", (Object)id);
        return id;
    }

    private List<File> getRulesFiles() throws IOException {
        Path droolsRulesRoot = this.rulesFolder.toPath();
        if (!droolsRulesRoot.toFile().isDirectory()) {
            throw new IllegalStateException("Expected to find Drools rules for alarmd in '" + droolsRulesRoot + "' but the path is not a directory! Aborting.");
        }
        return Files.find(droolsRulesRoot, 3, (path, attrs) -> attrs.isRegularFile() && path.toString().endsWith(".drl"), new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private static ReleaseId generateReleaseId() {
        KieServices ks = KieServices.Factory.get();
        String moduleName = UUID.randomUUID().toString();
        return ks.newReleaseId(ManagedDroolsContext.class.getPackage().getName(), moduleName, "1.0.0");
    }

    public void tick() {
        this.firing.set(true);
        this.lock.lock();
        try {
            this.kieSession.fireAllRules();
        }
        finally {
            this.lock.unlock();
            this.firing.set(false);
        }
    }

    protected void lockIfNotFiring() {
        if (Boolean.TRUE.equals(this.firing.get())) {
            this.lock.lock();
        }
    }

    protected void unlockIfNotFiring() {
        if (Boolean.TRUE.equals(this.firing.get())) {
            this.lock.unlock();
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.kieSession != null) {
            this.kieSession.halt();
            this.kieSession = null;
        }
        if (this.kieContainer != null) {
            this.kieContainer.dispose();
            this.kieContainer = null;
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public SessionPseudoClock getClock() {
        return this.clock;
    }

    public void setUsePseudoClock(boolean usePseudoClock) {
        this.usePseudoClock = usePseudoClock;
    }

    public void setUseManualTick(boolean useManualTick) {
        this.useManualTick = useManualTick;
    }

    public void setOnNewKiewSessionCallback(Consumer<KieSession> onNewKiewSessionCallback) {
        this.onNewKiewSessionCallback = onNewKiewSessionCallback;
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }
}

