/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import java.io.Serializable;
import java.util.Date;
import org.opennms.netmgt.alarmd.drools.AlarmService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAlarmService
implements AlarmService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmService.class);
    protected static final String DEFAULT_USER = "admin";
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private AlarmEntityNotifier alarmEntityNotifier;

    @Override
    @Transactional
    public void clearAlarm(OnmsAlarm alarm, Date clearTime) {
        LOG.info("Clearing alarm with id: {} with current severity: {} at: {}", new Object[]{alarm.getId(), alarm.getSeverity(), clearTime});
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping clear.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.CLEARED);
        DefaultAlarmService.updateAutomationTime(alarmInTrans, clearTime);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void deleteAlarm(OnmsAlarm alarm) {
        LOG.info("Deleting alarm with id: {} with severity: {}", (Object)alarm.getId(), (Object)alarm.getSeverity());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping delete.", (Object)alarm);
            return;
        }
        this.alarmDao.delete((Object)alarmInTrans);
        this.alarmEntityNotifier.didDeleteAlarm(alarmInTrans);
    }

    @Override
    @Transactional
    public void unclearAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Un-clearing alarm with id: {} at: {}", (Object)alarm.getId(), (Object)alarm.getLastEventTime());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping clear.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.get((int)alarmInTrans.getLastEvent().getEventSeverity()));
        DefaultAlarmService.updateAutomationTime(alarmInTrans, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void escalateAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Escalating alarm with id: {}", (Object)alarm.getId());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping escalate.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(OnmsSeverity.get((int)(previousSeverity.getId() + 1)));
        DefaultAlarmService.updateAutomationTime(alarmInTrans, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    @Override
    @Transactional
    public void acknowledgeAlarm(OnmsAlarm alarm, Date now) {
        LOG.info("Acknowledging alarm with id: {}", (Object)alarm.getId());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping ack.", (Object)alarm);
            return;
        }
        String previousAckUser = alarmInTrans.getAlarmAckUser();
        Date previousAckTime = alarmInTrans.getAlarmAckTime();
        alarmInTrans.setAlarmAckUser(DEFAULT_USER);
        alarmInTrans.setAlarmAckTime(now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didAcknowledgeAlarm(alarmInTrans, previousAckUser, previousAckTime);
    }

    @Override
    @Transactional
    public void setSeverity(OnmsAlarm alarm, OnmsSeverity severity, Date now) {
        LOG.info("Updating severity on alarm with id: {}", (Object)alarm.getId());
        OnmsAlarm alarmInTrans = (OnmsAlarm)this.alarmDao.get((Serializable)alarm.getId());
        if (alarmInTrans == null) {
            LOG.warn("Alarm disappeared: {}. Skipping severity update.", (Object)alarm);
            return;
        }
        OnmsSeverity previousSeverity = alarmInTrans.getSeverity();
        alarmInTrans.setSeverity(severity);
        DefaultAlarmService.updateAutomationTime(alarm, now);
        this.alarmDao.update((Object)alarmInTrans);
        this.alarmEntityNotifier.didUpdateAlarmSeverity(alarmInTrans, previousSeverity);
    }

    private static void updateAutomationTime(OnmsAlarm alarm, Date now) {
        if (alarm.getFirstAutomationTime() == null) {
            alarm.setFirstAutomationTime(now);
        }
        alarm.setLastAutomationTime(now);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.alarmDao = alarmDao;
    }

    public void setAlarmEntityNotifier(AlarmEntityNotifier alarmEntityNotifier) {
        this.alarmEntityNotifier = alarmEntityNotifier;
    }
}

