/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import com.google.common.util.concurrent.Striped;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.alarmd.Alarmd;
import org.opennms.netmgt.alarmd.StripedExt;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.Situation;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.UpdateField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.util.Assert;

public class AlarmPersisterImpl
implements AlarmPersister {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmPersisterImpl.class);
    protected static final Integer NUM_STRIPE_LOCKS = Integer.getInteger("org.opennms.alarmd.stripe.locks", Alarmd.THREADS * 4);
    private AlarmDao m_alarmDao;
    private EventDao m_eventDao;
    private EventForwarder m_eventForwarder;
    private EventUtil m_eventUtil;
    private TransactionOperations m_transactionOperations;
    private Striped<Lock> lockStripes = StripedExt.fairLock(NUM_STRIPE_LOCKS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnmsAlarm persist(Event event, boolean eagerlyLoadAlarm) {
        OnmsAlarmAndLifecycleEvent alarmAndEvent;
        if (!AlarmPersisterImpl.checkEventSanityAndDoWeProcess(event)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("process: {}; nodeid: {}; ipaddr: {}; serviceid: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService()});
        }
        Iterable locks = this.lockStripes.bulkGet(AlarmPersisterImpl.getLockKeys(event));
        try {
            locks.forEach(Lock::lock);
            alarmAndEvent = (OnmsAlarmAndLifecycleEvent)this.m_transactionOperations.execute(action -> this.addOrReduceEventAsAlarm(event, eagerlyLoadAlarm));
        }
        finally {
            locks.forEach(Lock::unlock);
        }
        this.m_eventForwarder.sendNow(alarmAndEvent.getEvent());
        return alarmAndEvent.getAlarm();
    }

    private OnmsAlarmAndLifecycleEvent addOrReduceEventAsAlarm(Event event, boolean eagerlyLoadAlarm) {
        EventBuilder ebldr;
        OnmsEvent e = (OnmsEvent)this.m_eventDao.get((Serializable)event.getDbid());
        Assert.notNull((Object)e, (String)"Event was deleted before we could retrieve it and create an alarm.");
        String reductionKey = event.getAlarmData().getReductionKey();
        LOG.debug("addOrReduceEventAsAlarm: looking for existing reduction key: {}", (Object)reductionKey);
        OnmsAlarm alarm = this.m_alarmDao.findByReductionKey(reductionKey);
        if (alarm == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} not found, instantiating new alarm", (Object)reductionKey);
            }
            alarm = this.createNewAlarm(e, event);
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)e);
            ebldr = new EventBuilder("uei.opennms.org/alarms/alarmCreated", "Alarmd");
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} found, reducing event to existing alarm: {}", (Object)reductionKey, (Object)alarm.getIpAddr());
            }
            this.reduceEvent(e, alarm, event);
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)e);
            if (event.getAlarmData().isAutoClean().booleanValue()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), e);
            }
            ebldr = new EventBuilder("uei.opennms.org/alarms/alarmUpdatedWithReducedEvent", "Alarmd");
        }
        if (eagerlyLoadAlarm) {
            if (alarm.getServiceType() != null) {
                alarm.getServiceType().getName();
            }
            if (alarm.getNodeId() != null) {
                alarm.getNode().getForeignSource();
            }
            Hibernate.initialize((Object)alarm.getEventParameters());
        }
        ebldr.addParam("alarmUei", alarm.getUei());
        ebldr.addParam("alarmId", alarm.getId().intValue());
        return new OnmsAlarmAndLifecycleEvent(alarm, ebldr.getEvent());
    }

    private void reduceEvent(OnmsEvent e, OnmsAlarm alarm, Event event) {
        alarm.setLastEvent(e);
        alarm.setLastEventTime(e.getEventTime());
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
        if (!event.getAlarmData().hasUpdateFields().booleanValue()) {
            alarm.setLogMsg(e.getEventLogMsg());
        } else {
            for (UpdateField field : event.getAlarmData().getUpdateFieldList()) {
                String fieldName = field.getFieldName();
                if (fieldName.equalsIgnoreCase("LogMsg") && !field.isUpdateOnReduction().booleanValue()) continue;
                alarm.setLogMsg(e.getEventLogMsg());
                if (field.isUpdateOnReduction().booleanValue()) {
                    if (fieldName.toLowerCase().startsWith("distpoller")) {
                        alarm.setDistPoller(e.getDistPoller());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("ipaddr")) {
                        alarm.setIpAddr(e.getIpAddr());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("mouseover")) {
                        alarm.setMouseOverText(e.getEventMouseOverText());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("operinstruct")) {
                        alarm.setOperInstruct(e.getEventOperInstruct());
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("severity")) {
                        alarm.setSeverity(OnmsSeverity.valueOf((String)e.getSeverityLabel()));
                        continue;
                    }
                    if (fieldName.toLowerCase().contains("descr")) {
                        alarm.setDescription(e.getEventDescr());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("acktime")) {
                        String expandedAckTime = this.m_eventUtil.expandParms(field.getValueExpression(), event);
                        if ("null".equalsIgnoreCase(expandedAckTime) && alarm.isAcknowledged()) {
                            alarm.unacknowledge("admin");
                            continue;
                        }
                        if ("".equals(expandedAckTime) || expandedAckTime.toLowerCase().startsWith("now")) {
                            alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                            continue;
                        }
                        if (expandedAckTime.matches("^\\d+$")) {
                            try {
                                long ackTimeLong = Long.valueOf(expandedAckTime);
                                if (ackTimeLong < 0xFA00000000L) {
                                    alarm.setAlarmAckTime(new Date(ackTimeLong * 1000L));
                                    continue;
                                }
                                alarm.setAlarmAckTime(new Date(ackTimeLong));
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Could not parse update-field 'acktime' value '{}' as a Long. Using current time instead.", (Object)expandedAckTime);
                                alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                            }
                            continue;
                        }
                        if (expandedAckTime.toLowerCase().matches("^0x[0-9a-f]{22}$") || expandedAckTime.toLowerCase().matches("^0x[0-9a-f]{16}$")) {
                            alarm.setAlarmAckTime(this.m_eventUtil.decodeSnmpV2TcDateAndTime(new BigInteger(expandedAckTime.substring(2), 16)));
                            continue;
                        }
                        LOG.warn("Not sure what to do with update-field 'acktime' value '{}'. Using current time instead.", (Object)expandedAckTime);
                        alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                        continue;
                    }
                    if (!fieldName.toLowerCase().startsWith("ackuser")) continue;
                    String expandedAckUser = this.m_eventUtil.expandParms(field.getValueExpression(), event);
                    if ("null".equalsIgnoreCase(expandedAckUser) || "".equals(expandedAckUser)) {
                        alarm.unacknowledge("admin");
                        continue;
                    }
                    alarm.setAlarmAckUser(expandedAckUser);
                    continue;
                }
                LOG.warn("reduceEvent: The specified field: {}, is not supported.", (Object)fieldName);
            }
        }
        Set<OnmsAlarm> containedAlarms = this.getAlarms(event.getParmCollection());
        if (containedAlarms != null && !containedAlarms.isEmpty()) {
            if (alarm instanceof Situation) {
                for (OnmsAlarm related : containedAlarms) {
                    ((Situation)alarm).addAlarm(related);
                }
            } else {
                LOG.warn("reduceEvent: Event {} attempts to add alarms to alarm that is not a Situation: {}.", (Object)event.getUei(), (Object)alarm);
            }
        }
        e.setAlarm(alarm);
    }

    private OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        OnmsAlarm alarm;
        Set<OnmsAlarm> containedAlarms = this.getAlarms(event.getParmCollection());
        if (containedAlarms == null || containedAlarms.isEmpty()) {
            alarm = new OnmsAlarm();
        } else {
            alarm = new Situation();
            ((Situation)alarm).setAlarms(containedAlarms);
        }
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        e.setAlarm(alarm);
        return alarm;
    }

    private Set<OnmsAlarm> getAlarms(List<Parm> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        Set reductionKeys = list.stream().filter(AlarmPersisterImpl::isRelatedReductionKeyWithContent).map(p -> p.getValue().getContent()).collect(Collectors.toSet());
        return reductionKeys.stream().map(reductionKey -> this.m_alarmDao.findByReductionKey(reductionKey)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean isRelatedReductionKeyWithContent(Parm param) {
        return param.getParmName() != null && param.getParmName().startsWith("related-reductionKey") && param.getValue() != null && param.getValue().getContent() != null;
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event) {
        Assert.notNull((Object)event, (String)"Incoming event was null, aborting");
        if (event.getLogmsg() != null && "donotpersist".equals(event.getLogmsg().getDest())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' marked as 'donotpersist'; not processing event.", (Object)event.getUei());
            }
            return false;
        }
        if (event.getAlarmData() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' has no alarm data; not processing event.", (Object)event.getUei());
            }
            return false;
        }
        Assert.isTrue((event.getDbid() > 0 ? 1 : 0) != 0, (String)("Incoming event has an illegal dbid (" + event.getDbid() + "), aborting"));
        return true;
    }

    private static Collection<String> getLockKeys(Event event) {
        if (event.getAlarmData().getClearKey() == null) {
            return Collections.singletonList(event.getAlarmData().getReductionKey());
        }
        return Arrays.asList(event.getAlarmData().getReductionKey(), event.getAlarmData().getClearKey());
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventUtil(EventUtil eventUtil) {
        this.m_eventUtil = eventUtil;
    }

    public EventUtil getEventUtil() {
        return this.m_eventUtil;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    private static class OnmsAlarmAndLifecycleEvent {
        private final OnmsAlarm m_alarm;
        private final Event m_event;

        public OnmsAlarmAndLifecycleEvent(OnmsAlarm alarm, Event event) {
            this.m_alarm = alarm;
            this.m_event = event;
        }

        public OnmsAlarm getAlarm() {
            return this.m_alarm;
        }

        public Event getEvent() {
            return this.m_event;
        }
    }
}

