/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleSubscriptionService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@EventListener(name="alarmLifecycleListenerManager", logPrefix="alarmd")
public class AlarmLifecycleListenerManager
implements AlarmLifecycleSubscriptionService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmLifecycleListenerManager.class);
    private final Set<AlarmLifecycleListener> listeners = new LinkedHashSet<AlarmLifecycleListener>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private TransactionTemplate template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(ueis={"uei.opennms.org/alarms/alarmCreated", "uei.opennms.org/alarms/alarmEscalated", "uei.opennms.org/alarms/alarmCleared", "uei.opennms.org/alarms/alarmUncleared", "uei.opennms.org/alarms/alarmUpdatedWithReducedEvent", "uei.opennms.org/alarms/alarmDeleted"})
    public void handleAlarmLifecycleEvents(Event e) {
        this.rwLock.readLock().lock();
        try {
            int alarmId;
            if (e == null || this.listeners.size() < 1) {
                return;
            }
            Parm alarmIdParm = e.getParm("alarmId");
            if (alarmIdParm == null || alarmIdParm.getValue() == null) {
                LOG.warn("The alarmId parameter has no value on event with uei: {}. Ignoring.", (Object)e.getUei());
                return;
            }
            try {
                alarmId = Integer.parseInt(alarmIdParm.getValue().getContent());
            }
            catch (NumberFormatException ee) {
                LOG.warn("Failed to retrieve the alarmId for event with uei: {}. Ignoring.", (Object)e.getUei(), (Object)ee);
                this.rwLock.readLock().unlock();
                return;
            }
            if ("uei.opennms.org/alarms/alarmDeleted".equals(e.getUei())) {
                Parm reductionKeyParm = e.getParm("alarmReductionKey");
                if (reductionKeyParm == null) {
                    LOG.warn("Received alarm deleted event without reduction key. Ignoring.");
                    return;
                }
                if (reductionKeyParm.getValue() == null) {
                    LOG.warn("Received alarm deleted event with null reduction key value. Ignoring.");
                    return;
                }
                String reductionKey = reductionKeyParm.getValue().getContent();
                if (reductionKey == null) {
                    LOG.warn("Received alarm deleted event with null reduction key content. Ignoring.");
                    return;
                }
                this.handleAlarmDeleted(alarmId, reductionKey);
            } else {
                this.handleAlarmCreatedOrUpdated(e, alarmId);
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void handleAlarmCreatedOrUpdated(final Event e, final int alarmId) {
        this.template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                OnmsAlarm alarm = (OnmsAlarm)AlarmLifecycleListenerManager.this.alarmDao.get((Serializable)Integer.valueOf(alarmId));
                if (alarm == null) {
                    LOG.error("Could not find alarm with id: {} for event with uei: {}. Ignoring.", (Object)alarmId, (Object)e.getUei());
                    return;
                }
                AlarmLifecycleListenerManager.this.listeners.forEach(l -> l.handleNewOrUpdatedAlarm(alarm));
            }
        });
    }

    private void handleAlarmDeleted(int alarmId, String reductionKey) {
        this.listeners.forEach(l -> l.handleDeletedAlarm(alarmId, reductionKey));
    }

    public void addAlarmLifecyleListener(AlarmLifecycleListener listener) {
        this.rwLock.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void removeAlarmLifecycleListener(AlarmLifecycleListener listener) {
        this.rwLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

