/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.util.List;
import java.util.Map;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@EventListener(name="Alarmd", logPrefix="alarmd")
public class Alarmd
implements SpringServiceDaemon,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(Alarmd.class);
    public static final String NAME = "Alarmd";
    private EventForwarder m_eventForwarder;
    private List<Northbounder> m_northboundInterfaces;
    private AlarmPersister m_persister;

    @EventHandler(uei="*")
    public void onEvent(Event e) {
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
            this.handleReloadEvent(e);
            return;
        }
        OnmsAlarm alarm = this.m_persister.persist(e);
        if (alarm != null) {
            NorthboundAlarm a = new NorthboundAlarm(alarm);
            for (Northbounder nbi : this.m_northboundInterfaces) {
                nbi.onAlarm(a);
            }
        }
    }

    private void handleReloadEvent(Event e) {
        LOG.info("Received reload configuration event: {}", (Object)e);
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            String parmName = parm.getParmName();
            if (!"daemonName".equals(parmName)) continue;
            if (parm.getValue() == null || parm.getValue().getContent() == null) {
                LOG.warn("The daemonName parameter has no value, ignoring.");
                return;
            }
            List<Northbounder> nbis = this.getNorthboundInterfaces();
            for (Northbounder nbi : nbis) {
                if (!parm.getValue().getContent().contains(nbi.getName())) continue;
                LOG.debug("Handling reload event for NBI: {}", (Object)nbi.getName());
                LOG.debug("Reloading NBI configuration for interface {} not yet implemented.", (Object)nbi.getName());
                nbi.reloadConfig();
                return;
            }
        }
    }

    public void setPersister(AlarmPersister persister) {
        this.m_persister = persister;
    }

    public AlarmPersister getPersister() {
        return this.m_persister;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getNorthboundInterfaces() != null) {
            for (Northbounder nb : this.getNorthboundInterfaces()) {
                nb.start();
            }
        }
    }

    public void destroy() throws Exception {
    }

    public String getName() {
        return NAME;
    }

    public void start() throws Exception {
    }

    public void onNorthbounderRegistered(Northbounder northbounder, Map<String, String> properties) {
        northbounder.start();
    }

    public void onNorthbounderUnregistered(Northbounder northbounder, Map<String, String> properties) {
        northbounder.stop();
    }

    public List<Northbounder> getNorthboundInterfaces() {
        return this.m_northboundInterfaces;
    }

    public void setNorthboundInterfaces(List<Northbounder> northboundInterfaces) {
        this.m_northboundInterfaces = northboundInterfaces;
    }
}

