/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.io.Serializable;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.UpdateField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AlarmPersisterImpl
implements AlarmPersister {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmPersisterImpl.class);
    private AlarmDao m_alarmDao;
    private EventDao m_eventDao;

    @Override
    public OnmsAlarm persist(Event event) {
        if (!AlarmPersisterImpl.checkEventSanityAndDoWeProcess(event)) {
            return null;
        }
        LOG.debug("process: {}; nodeid: {}; ipaddr: {}; serviceid: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService()});
        return this.addOrReduceEventAsAlarm(event);
    }

    private OnmsAlarm addOrReduceEventAsAlarm(Event event) {
        Assert.notNull((Object)event, (String)"Incoming event was null, aborting");
        Assert.isTrue((event.getDbid() > 0 ? 1 : 0) != 0, (String)("Incoming event has an illegal dbid (" + event.getDbid() + "), aborting"));
        OnmsEvent e = (OnmsEvent)this.m_eventDao.get((Serializable)event.getDbid());
        Assert.notNull((Object)e, (String)"Event was deleted before we could retrieve it and create an alarm.");
        String reductionKey = event.getAlarmData().getReductionKey();
        LOG.debug("addOrReduceEventAsAlarm: looking for existing reduction key: {}", (Object)reductionKey);
        OnmsAlarm alarm = this.m_alarmDao.findByReductionKey(reductionKey);
        if (alarm == null) {
            LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} not found, instantiating new alarm", (Object)reductionKey);
            alarm = AlarmPersisterImpl.createNewAlarm(e, event);
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)e);
        } else {
            LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} found, reducing event to existing alarm: {}", (Object)reductionKey, (Object)alarm.getIpAddr());
            AlarmPersisterImpl.reduceEvent(e, alarm, event);
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)e);
            if (event.getAlarmData().isAutoClean().booleanValue()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), e);
            }
        }
        return alarm;
    }

    private static void reduceEvent(OnmsEvent e, OnmsAlarm alarm, Event event) {
        alarm.setLastEvent(e);
        alarm.setLastEventTime(e.getEventTime());
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
        if (!event.getAlarmData().hasUpdateFields().booleanValue()) {
            alarm.setLogMsg(e.getEventLogMsg());
            alarm.setEventParms(e.getEventParms());
        } else {
            for (UpdateField field : event.getAlarmData().getUpdateFieldList()) {
                if (field.getFieldName().equalsIgnoreCase("LogMsg") && !field.isUpdateOnReduction().booleanValue()) continue;
                alarm.setLogMsg(e.getEventLogMsg());
                if (field.getFieldName().equalsIgnoreCase("Parms") && !field.isUpdateOnReduction().booleanValue()) continue;
                alarm.setEventParms(e.getEventParms());
                if (!field.isUpdateOnReduction().booleanValue()) continue;
                if (field.getFieldName().toLowerCase().startsWith("distpoller")) {
                    alarm.setDistPoller(e.getDistPoller());
                    continue;
                }
                if (field.getFieldName().toLowerCase().startsWith("ipaddr")) {
                    alarm.setIpAddr(e.getIpAddr());
                    continue;
                }
                if (field.getFieldName().toLowerCase().startsWith("mouseover")) {
                    alarm.setMouseOverText(e.getEventMouseOverText());
                    continue;
                }
                if (field.getFieldName().toLowerCase().startsWith("operinstruct")) {
                    alarm.setOperInstruct(e.getEventOperInstruct());
                    continue;
                }
                if (field.getFieldName().equalsIgnoreCase("severity")) {
                    alarm.setSeverity(OnmsSeverity.valueOf((String)e.getSeverityLabel()));
                    continue;
                }
                if (field.getFieldName().toLowerCase().contains("descr")) {
                    alarm.setDescription(e.getEventDescr());
                    alarm.setSeverity(OnmsSeverity.valueOf((String)e.getSeverityLabel()));
                    continue;
                }
                LOG.warn("reduceEvent: The specified field: {}, is not supported.", (Object)field.getFieldName());
            }
        }
        e.setAlarm(alarm);
    }

    private static OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        if (e.getServiceType() != null) {
            e.getServiceType().getName();
        }
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setEventParms(e.getEventParms());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        e.setAlarm(alarm);
        return alarm;
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        if (event.getLogmsg() != null && event.getLogmsg().getDest() != null && "donotpersist".equals(event.getLogmsg().getDest())) {
            LOG.debug("checkEventSanity: uei '{}' marked as 'donotpersist'; not processing event.", (Object)event.getUei());
            return false;
        }
        if (event.getAlarmData() == null) {
            LOG.debug("checkEventSanity: uei '{}' has no alarm data; not processing event.", (Object)event.getUei());
            return false;
        }
        return true;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }
}

