/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.HashMap;
import java.util.Map;
import org.graylog2.syslog4j.Syslog;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SyslogNorthbounderManager
implements InitializingBean,
Northbounder,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogNorthbounderManager.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private SyslogNorthbounderConfigDao m_configDao;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        this.m_registrations.put(this.getName(), this.m_serviceRegistry.register((Object)this, new Class[]{Northbounder.class}));
        this.registerNorthnounders();
    }

    private void registerNorthnounders() throws Exception {
        if (!this.m_configDao.getConfig().isEnabled().booleanValue()) {
            LOG.warn("The Syslog NBI is globally disabled, the destinations won't be registered which means all the alarms will be rejected.");
            return;
        }
        for (SyslogDestination syslogDestination : this.m_configDao.getConfig().getDestinations()) {
            LOG.info("Registering syslog northbound configuration for destination {}.", (Object)syslogDestination.getName());
            SyslogNorthbounder nbi = new SyslogNorthbounder(this.m_configDao, syslogDestination.getName());
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        this.m_registrations.values().forEach(Registration::unregister);
        try {
            Syslog.shutdown();
        }
        catch (Exception e) {
            LOG.error("Can't shutdown the syslog instances", (Throwable)e);
        }
    }

    public void start() throws NorthbounderException {
    }

    public boolean isReady() {
        return false;
    }

    public void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
    }

    public void stop() throws NorthbounderException {
    }

    public String getName() {
        return "SyslogNBI";
    }

    public void reloadConfig() throws NorthbounderException {
        LOG.info("Reloading Syslog northbound configuration.");
        try {
            this.m_configDao.reload();
            this.m_registrations.forEach((k, v) -> {
                if (k != this.getName()) {
                    v.unregister();
                }
            });
            Syslog.shutdown();
            this.registerNorthnounders();
        }
        catch (Exception e) {
            throw new NorthbounderException("Can't reload the Syslog northbound configuration", (Throwable)e);
        }
    }
}

