/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.List;
import java.util.Map;
import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfigDao;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SyslogNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogNorthbounder.class);
    protected static final String NBI_NAME = "SyslogNBI";
    private SyslogNorthbounderConfigDao m_configDao;
    private SyslogDestination m_destination;
    private boolean initialized = false;

    public SyslogNorthbounder(SyslogNorthbounderConfigDao configDao, String destination) {
        super("SyslogNBI:" + destination);
        this.m_configDao = configDao;
        this.m_destination = configDao.getConfig().getSyslogDestination(destination);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_destination == null) {
            LOG.error("Syslog Northbounder {} is currently disabled because it has not been initialized correctly or there is a problem with the configuration.", (Object)this.getName());
            this.initialized = false;
            return;
        }
        SyslogUtils.createNorthboundInstance(this.m_destination);
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
        this.initialized = true;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.initialized) {
            LOG.warn("Syslog Northbounder {} has not been properly initialized, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        if (!this.getConfig().isEnabled().booleanValue()) {
            LOG.warn("Syslog Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            if (this.m_destination.getFilters() == null) {
                return true;
            }
            boolean passed = this.m_destination.passFilter(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public boolean isReady() {
        return this.initialized && this.getConfig().isEnabled() != false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        SyslogIF instance;
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for syslog forwarding.";
            IllegalStateException e = new IllegalStateException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to destination:{}", (Object)alarms.size(), (Object)this.m_destination.getName());
        try {
            instance = Syslog.getInstance((String)this.m_destination.getName());
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not find Syslog instance for destination: '{}': {}", (Object)this.m_destination.getName(), (Object)e);
            throw e;
        }
        for (NorthboundAlarm alarm : alarms) {
            Integer count = alarm.getCount();
            if (count > 1 && this.m_destination.isFirstOccurrenceOnly()) {
                LOG.debug("Destination {} is configured for new alarm instances only.  Alarm has count of {}.", (Object)this.m_destination.getName(), (Object)count);
                continue;
            }
            LOG.debug("Creating formatted log message for alarm: {}.", (Object)alarm.getId());
            try {
                LOG.debug("Making substitutions for tokens in message format for alarm: {}.", (Object)alarm.getId());
                String msgFormat = this.m_destination.getCustomMessageFormat(alarm);
                if (msgFormat == null) {
                    msgFormat = this.getConfig().getMessageFormat();
                }
                String syslogMessage = PropertiesUtils.substitute((String)msgFormat, (Map[])new Map[]{this.createMapping(alarm)});
                LOG.debug("Determining LOG_LEVEL for alarm: {}", (Object)alarm.getId());
                int level = SyslogUtils.determineLogLevel(alarm.getSeverity());
                LOG.debug("Forwarding alarm: {} via syslog to destination: {}", (Object)alarm.getId(), (Object)this.m_destination.getName());
                instance.log(level, syslogMessage);
            }
            catch (Exception ex) {
                LOG.error("Caught exception sending to destination: '{}': {}", (Object)this.m_destination.getName(), (Object)ex);
            }
        }
    }

    public SyslogNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }
}

