/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="syslog-filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogFilter.class);
    @XmlAttribute(name="enabled", required=false)
    private Boolean m_enabled;
    @XmlAttribute(name="name", required=false)
    private String m_name;
    @XmlElement(name="rule", required=true)
    private String m_rule;
    @XmlElement(name="message-format", required=false)
    private String m_messageFormat;

    public SyslogFilter() {
    }

    public SyslogFilter(String name, String rule, String messageFormat) {
        this.m_name = name;
        this.m_rule = rule;
        this.m_messageFormat = messageFormat;
    }

    public Boolean isEnabled() {
        return this.m_enabled == null ? Boolean.TRUE : this.m_enabled;
    }

    public String getName() {
        return this.m_name;
    }

    public String getRule() {
        return this.m_rule;
    }

    public String getMessageFormat() {
        return this.m_messageFormat;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public void setMessageFormat(String messageFormat) {
        this.m_messageFormat = messageFormat;
    }

    public boolean passFilter(NorthboundAlarm alarm) {
        if (!this.isEnabled().booleanValue()) {
            return false;
        }
        StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(this.getRule());
        boolean passed = false;
        try {
            passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOG.warn("passFilter: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getRule(), alarm.getUei(), e.getMessage()});
        }
        LOG.debug("passFilter: checking {} ? {}", (Object)this.getRule(), (Object)passed);
        return passed;
    }
}

