/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.util.List;
import java.util.Map;
import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogNorthbounderConfigDao;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SyslogNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogNorthbounder.class);
    protected static final String NBI_NAME = "SyslogNBI";
    private SyslogNorthbounderConfigDao m_configDao;
    private SyslogDestination m_destination;

    public SyslogNorthbounder(SyslogNorthbounderConfigDao configDao, String destination) {
        super("SyslogNBI:" + destination);
        this.m_configDao = configDao;
        this.m_destination = configDao.getSyslogDestination(destination);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_destination == null) {
            LOG.info("Syslog Northbounder is currently disabled, rejecting alarm.");
            String msg = "Syslog forwarding configuration is not initialized.";
            IllegalStateException e = new IllegalStateException(msg);
            LOG.error(msg, (Throwable)e);
            throw e;
        }
        this.createNorthboundInstance();
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
    }

    protected void onStop() {
        Syslog.destroyInstance((String)this.getName());
        super.onStop();
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.getConfig().isEnabled().booleanValue()) {
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            if (this.m_destination.getFilters() == null) {
                return true;
            }
            boolean passed = this.m_destination.passFilter(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        SyslogIF instance;
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for syslog forwarding.";
            IllegalStateException e = new IllegalStateException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to destination:{}", (Object)alarms.size(), (Object)this.m_destination.getName());
        try {
            instance = Syslog.getInstance((String)this.m_destination.getName());
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not find Syslog instance for destination: '{}': {}", (Object)this.m_destination.getName(), (Object)e);
            throw e;
        }
        for (NorthboundAlarm alarm : alarms) {
            Integer count = alarm.getCount();
            if (count > 1 && this.m_destination.isFirstOccurrenceOnly()) {
                LOG.debug("Destination {} is configured for new alarm instances only.  Alarm has count of {}.", (Object)this.m_destination.getName(), (Object)count);
                continue;
            }
            LOG.debug("Creating formatted log message for alarm: {}.", (Object)alarm.getId());
            try {
                LOG.debug("Making substitutions for tokens in message format for alarm: {}.", (Object)alarm.getId());
                String msgFormat = this.m_destination.getCustomMessageFormat(alarm);
                if (msgFormat == null) {
                    msgFormat = this.getConfig().getMessageFormat();
                }
                String syslogMessage = PropertiesUtils.substitute((String)msgFormat, (Map[])new Map[]{this.createMapping(alarm)});
                LOG.debug("Determining LOG_LEVEL for alarm: {}", (Object)alarm.getId());
                int level = this.determineLogLevel(alarm.getSeverity());
                LOG.debug("Forwarding alarm: {} via syslog to destination: {}", (Object)alarm.getId(), (Object)this.m_destination.getName());
                instance.log(level, syslogMessage);
            }
            catch (Exception ex) {
                LOG.error("Caught exception sending to destination: '{}': {}", (Object)this.m_destination.getName(), (Object)ex);
            }
        }
    }

    private void createNorthboundInstance() throws SyslogRuntimeException {
        LOG.info("Creating Syslog Northbound Instance {}", (Object)this.m_destination.getName());
        String instName = this.m_destination.getName();
        int facility = this.convertFacility(this.m_destination.getFacility());
        SyslogDestination.SyslogProtocol protocol = this.m_destination.getProtocol();
        SyslogConfigIF instanceConfiguration = this.createConfig(this.m_destination, protocol, facility);
        instanceConfiguration.setIdent("OpenNMS");
        instanceConfiguration.setCharSet(this.m_destination.getCharSet());
        instanceConfiguration.setMaxMessageLength(this.m_destination.getMaxMessageLength());
        instanceConfiguration.setSendLocalName(this.m_destination.isSendLocalName());
        instanceConfiguration.setSendLocalTimestamp(this.m_destination.isSendLocalTime());
        instanceConfiguration.setTruncateMessage(this.m_destination.isTruncateMessage());
        instanceConfiguration.setUseStructuredData(false);
        try {
            Syslog.createInstance((String)instName, (SyslogConfigIF)instanceConfiguration);
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not create northbound instance, '{}': {}", (Object)instName, (Object)e);
            throw e;
        }
    }

    private SyslogConfigIF createConfig(SyslogDestination dest, SyslogDestination.SyslogProtocol protocol, int fac) {
        UDPNetSyslogConfig config;
        switch (protocol) {
            case UDP: {
                config = new UDPNetSyslogConfig(fac, dest.getHost(), dest.getPort());
                break;
            }
            case TCP: {
                config = new TCPNetSyslogConfig(fac, dest.getHost(), dest.getPort());
                break;
            }
            default: {
                config = new UDPNetSyslogConfig(fac, "localhost", 514);
            }
        }
        return config;
    }

    private int convertFacility(SyslogDestination.SyslogFacility facility) {
        int fac;
        switch (facility) {
            case KERN: {
                fac = 0;
                break;
            }
            case USER: {
                fac = 8;
                break;
            }
            case MAIL: {
                fac = 16;
                break;
            }
            case DAEMON: {
                fac = 24;
                break;
            }
            case AUTH: {
                fac = 32;
                break;
            }
            case SYSLOG: {
                fac = 40;
                break;
            }
            case LPR: {
                fac = 48;
                break;
            }
            case NEWS: {
                fac = 56;
                break;
            }
            case UUCP: {
                fac = 64;
                break;
            }
            case CRON: {
                fac = 72;
                break;
            }
            case AUTHPRIV: {
                fac = 80;
                break;
            }
            case FTP: {
                fac = 88;
                break;
            }
            case LOCAL0: {
                fac = 128;
                break;
            }
            case LOCAL1: {
                fac = 136;
                break;
            }
            case LOCAL2: {
                fac = 144;
                break;
            }
            case LOCAL3: {
                fac = 152;
                break;
            }
            case LOCAL4: {
                fac = 160;
                break;
            }
            case LOCAL5: {
                fac = 168;
                break;
            }
            case LOCAL6: {
                fac = 176;
                break;
            }
            case LOCAL7: {
                fac = 184;
                break;
            }
            default: {
                fac = 8;
            }
        }
        return fac;
    }

    private int determineLogLevel(OnmsSeverity severity) {
        int level;
        switch (severity) {
            case CRITICAL: {
                level = 2;
                break;
            }
            case MAJOR: {
                level = 3;
                break;
            }
            case MINOR: {
                level = 3;
                break;
            }
            case WARNING: {
                level = 4;
                break;
            }
            case NORMAL: {
                level = 5;
                break;
            }
            case CLEARED: {
                level = 6;
                break;
            }
            case INDETERMINATE: {
                level = 7;
                break;
            }
            default: {
                level = 4;
            }
        }
        return level;
    }

    public SyslogNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }
}

